/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.context.offset;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import java.util.Map;

public class PartitionOffset {
    private static final String OFFSET_KEY = "offset";
    private static final String DEBUG_START_TIME_KEY = "startTime";
    private static final String DEBUG_QUERY_STARTED_AT_KEY = "queryStartedAt";
    private final Timestamp offset;
    private final StreamEventMetadata metadata;

    public PartitionOffset(Timestamp offset, StreamEventMetadata metadata) {
        this.offset = offset;
        this.metadata = metadata;
    }

    public Map<String, String> getOffset() {
        return Map.of(OFFSET_KEY, this.offset.toString(), DEBUG_START_TIME_KEY, this.metadata.getPartitionStartTimestamp().toString(), DEBUG_QUERY_STARTED_AT_KEY, this.metadata.getQueryStartedAt() != null ? this.metadata.getQueryStartedAt().toString() : "");
    }

    public static Timestamp extractOffset(Map<String, ?> offsets) {
        if (offsets == null) {
            return null;
        }
        String offset = (String)offsets.get(OFFSET_KEY);
        return offset == null ? null : Timestamp.parseTimestamp((String)offset);
    }
}

