/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;

public class SyncEventConsumerFactory<K, V> {
    private final SpannerConnectorConfig config;
    private final boolean autoCommitEnabled;

    public SyncEventConsumerFactory(SpannerConnectorConfig config, boolean autoCommitEnabled) {
        this.config = config;
        this.autoCommitEnabled = autoCommitEnabled;
    }

    public SpannerConnectorConfig getConfig() {
        return this.config;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public Consumer<K, V> createConsumer(String consumerGroup) {
        Properties props = this.config.kafkaProps(Map.of("group.id", consumerGroup, "key.deserializer", StringDeserializer.class.getName(), "value.deserializer", ByteArrayDeserializer.class.getName(), "auto.offset.reset", "earliest", "enable.auto.commit", this.autoCommitEnabled));
        return new KafkaConsumer(props);
    }
}

