/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.offset.PartitionOffset;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.OffsetReceivingTimeMetricEvent;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.storage.OffsetStorageReader;

public class PartitionOffsetProvider {
    private final OffsetStorageReader offsetStorageReader;
    private final MetricsEventPublisher metricsEventPublisher;

    public PartitionOffsetProvider(OffsetStorageReader offsetStorageReader, MetricsEventPublisher metricsEventPublisherr) {
        this.offsetStorageReader = offsetStorageReader;
        this.metricsEventPublisher = metricsEventPublisherr;
    }

    public Timestamp getOffset(String token) {
        Instant startTime = Instant.now();
        Map result = this.offsetStorageReader.offset(new SpannerPartition(token).getSourcePartition());
        if (result == null) {
            return null;
        }
        this.metricsEventPublisher.publishMetricEvent(OffsetReceivingTimeMetricEvent.from(startTime));
        return PartitionOffset.extractOffset(result);
    }

    public Map<String, String> getOffsetMap(String token) {
        Map result = this.offsetStorageReader.offset(new SpannerPartition(token).getSourcePartition());
        if (result == null) {
            return Map.of();
        }
        return result;
    }

    public Map<String, Timestamp> getOffsets(Collection<String> partitions) {
        Instant startTime = Instant.now();
        List partitionsMapList = partitions.stream().map(token -> new SpannerPartition((String)token).getSourcePartition()).collect(Collectors.toList());
        Map result = this.offsetStorageReader.offsets(partitionsMapList);
        if (result == null) {
            return Map.of();
        }
        this.metricsEventPublisher.publishMetricEvent(OffsetReceivingTimeMetricEvent.from(startTime));
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        for (Map.Entry entry : result.entrySet()) {
            map.put(SpannerPartition.extractToken((Map)entry.getKey()), PartitionOffset.extractOffset((Map)entry.getValue()));
        }
        return map;
    }
}

