/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.db.stream.ChangeStream;
import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.internal.TaskSyncPublisher;
import io.debezium.connector.spanner.task.PartitionFactory;
import io.debezium.connector.spanner.task.TaskStateUtil;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.TaskSyncContextHolder;
import io.debezium.connector.spanner.task.operation.ChildPartitionOperation;
import io.debezium.connector.spanner.task.operation.ClearSharedPartitionOperation;
import io.debezium.connector.spanner.task.operation.ConnectorEndDetectionOperation;
import io.debezium.connector.spanner.task.operation.FindPartitionForStreamingOperation;
import io.debezium.connector.spanner.task.operation.Operation;
import io.debezium.connector.spanner.task.operation.PartitionStatusUpdateOperation;
import io.debezium.connector.spanner.task.operation.RemoveFinishedPartitionOperation;
import io.debezium.connector.spanner.task.operation.TakePartitionForStreamingOperation;
import io.debezium.connector.spanner.task.operation.TakeSharedPartitionOperation;
import io.debezium.connector.spanner.task.state.NewPartitionsEvent;
import io.debezium.connector.spanner.task.state.PartitionStatusUpdateEvent;
import io.debezium.connector.spanner.task.state.SyncEvent;
import io.debezium.connector.spanner.task.state.TaskStateChangeEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateChangeEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStateChangeEventHandler.class);
    private final TaskSyncContextHolder taskSyncContextHolder;
    private final TaskSyncPublisher taskSyncPublisher;
    private final ChangeStream changeStream;
    private final PartitionFactory partitionFactory;
    private final Runnable finishingHandler;
    private final SpannerConnectorConfig connectorConfig;
    private final Consumer<RuntimeException> errorHandler;
    private final AtomicLong failOverloadedTaskTimer = new AtomicLong(System.currentTimeMillis());

    public TaskStateChangeEventHandler(TaskSyncContextHolder taskSyncContextHolder, TaskSyncPublisher taskSyncPublisher, ChangeStream changeStream, PartitionFactory partitionFactory, Runnable finishingHandler, SpannerConnectorConfig connectorConfig, Consumer<RuntimeException> errorHandler) {
        this.taskSyncContextHolder = taskSyncContextHolder;
        this.taskSyncPublisher = taskSyncPublisher;
        this.partitionFactory = partitionFactory;
        this.changeStream = changeStream;
        this.finishingHandler = finishingHandler;
        this.connectorConfig = connectorConfig;
        this.errorHandler = errorHandler;
    }

    public void processEvent(TaskStateChangeEvent syncEvent) throws InterruptedException {
        LOGGER.debug("process TaskStateChangeEvent of type: {}", (Object)syncEvent.getClass().getSimpleName());
        if (syncEvent instanceof PartitionStatusUpdateEvent) {
            this.processEvent((PartitionStatusUpdateEvent)syncEvent);
        } else if (syncEvent instanceof NewPartitionsEvent) {
            this.processEvent((NewPartitionsEvent)syncEvent);
        } else if (syncEvent instanceof SyncEvent) {
            this.processSyncEvent();
        } else {
            throw new IllegalStateException("Unknown event");
        }
    }

    private void processEvent(PartitionStatusUpdateEvent event) throws InterruptedException {
        this.performOperation(new PartitionStatusUpdateOperation(event.getToken(), event.getState()), new FindPartitionForStreamingOperation(), new TakePartitionForStreamingOperation(this.changeStream, this.partitionFactory), new RemoveFinishedPartitionOperation());
    }

    private void processEvent(NewPartitionsEvent newPartitionsEvent) throws InterruptedException {
        this.performOperation(new ChildPartitionOperation(newPartitionsEvent.getPartitions()), new FindPartitionForStreamingOperation(), new TakePartitionForStreamingOperation(this.changeStream, this.partitionFactory), new RemoveFinishedPartitionOperation());
    }

    private void processSyncEvent() throws InterruptedException {
        TaskSyncContext taskSyncContext = this.performOperation(new ClearSharedPartitionOperation(), new TakeSharedPartitionOperation(), new FindPartitionForStreamingOperation(), new TakePartitionForStreamingOperation(this.changeStream, this.partitionFactory), new RemoveFinishedPartitionOperation(), new ConnectorEndDetectionOperation(this.finishingHandler, this.connectorConfig.endTime()));
        this.failOverloadedTaskByTimer(taskSyncContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failOverloadedTaskByTimer(TaskSyncContext taskSyncContext) {
        if (!this.connectorConfig.failOverloadedTask()) {
            return;
        }
        TaskStateChangeEventHandler taskStateChangeEventHandler = this;
        synchronized (taskStateChangeEventHandler) {
            this.failOverloadedTaskTimer.getAndUpdate(start -> {
                long now = System.currentTimeMillis();
                if (start + this.connectorConfig.failOverloadedTaskInterval() < now) {
                    this.checkToFailOverloadedTask(taskSyncContext);
                    return now;
                }
                return start;
            });
        }
    }

    private synchronized void checkToFailOverloadedTask(TaskSyncContext taskSyncContext) {
        long currentTaskPartitions = TaskStateUtil.numOwnedAndAssignedPartitions(taskSyncContext);
        long totalPartitions = TaskStateUtil.totalInProgressPartitions(taskSyncContext);
        if (currentTaskPartitions > (long)this.connectorConfig.getDesiredPartitionsTasks() && currentTaskPartitions > 2L * (totalPartitions / (long)(taskSyncContext.getTaskStates().size() + 1))) {
            this.errorHandler.accept(new SpannerConnectorException(String.format("Task is overloaded by assignments: %d of total: %d", currentTaskPartitions, totalPartitions)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskSyncContext performOperation(Operation ... operations) throws InterruptedException {
        TaskSyncContext taskSyncContext;
        AtomicBoolean publishTaskSyncEvent = new AtomicBoolean(false);
        this.taskSyncContextHolder.lock();
        try {
            taskSyncContext = this.taskSyncContextHolder.updateAndGet(context -> {
                TaskSyncContext newContext = context;
                for (Operation operation : operations) {
                    newContext = operation.doOperation(newContext);
                    if (!operation.isRequiredPublishSyncEvent()) continue;
                    LOGGER.debug("Task {} - need to publish sync event for operation {}", (Object)this.taskSyncContextHolder.get().getTaskUid(), (Object)operation.getClass().getSimpleName());
                    publishTaskSyncEvent.set(true);
                }
                return newContext;
            });
        }
        finally {
            this.taskSyncContextHolder.unlock();
        }
        if (publishTaskSyncEvent.get()) {
            LOGGER.debug("Task {} - send sync event", (Object)taskSyncContext.getTaskUid());
            this.taskSyncPublisher.send(taskSyncContext.buildTaskSyncEvent());
        }
        return taskSyncContext;
    }
}

