/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.leader.rebalancer;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.leader.rebalancer.TaskPartitionRebalancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskPartitionGreedyLeaderRebalancer
implements TaskPartitionRebalancer {
    @Override
    public TaskState rebalance(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTaskStates) {
        survivedTasks = this.excludeLeader(leaderTaskState.getTaskUid(), survivedTasks);
        TaskState newLeaderTaskState = this.moveFinishedPartitionsFromObsoleteTasks(leaderTaskState, obsoleteTaskStates);
        newLeaderTaskState = this.movePartitionsFromObsoleteTasks(newLeaderTaskState, obsoleteTaskStates);
        newLeaderTaskState = this.moveSharedPartitionsFromObsoleteTasks(newLeaderTaskState, survivedTasks, obsoleteTaskStates);
        return this.takeSharedPartitionsFromSurvivedTasks(newLeaderTaskState, survivedTasks);
    }

    private Map<String, TaskState> excludeLeader(String leaderTaskUid, Map<String, TaskState> tasks) {
        tasks = new HashMap<String, TaskState>(tasks);
        tasks.remove(leaderTaskUid);
        return tasks;
    }

    private TaskState movePartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(leaderTaskState);
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List partitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (PartitionStateEnum.SCHEDULED.equals((Object)partitionState.getState()) || PartitionStateEnum.RUNNING.equals((Object)partitionState.getState())) {
                return partitionState.toBuilder().state(PartitionStateEnum.READY_FOR_STREAMING).assigneeTaskUid(leaderTaskState.getTaskUid()).build();
            }
            return partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build();
        }).collect(Collectors.toList());
        leaderPartitionList.addAll(partitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
    }

    private TaskState moveSharedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(leaderTaskState);
        String leaderUid = leaderTaskState.getTaskUid();
        List<PartitionState> obsoleteTasksSharedPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList()));
        ArrayList<PartitionState> leaderSharedPartitionList = new ArrayList<PartitionState>(leaderTaskState.getSharedPartitions());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List newSharedPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (survivedTasks.containsKey(partitionState.getAssigneeTaskUid()) && !partitionState.getAssigneeTaskUid().equals(leaderUid)) {
                return partitionState;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderSharedPartitionList.addAll(newSharedPartitions);
        List newPartitions = obsoleteTasksSharedPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (!survivedTasks.containsKey(partitionState.getAssigneeTaskUid()) || partitionState.getAssigneeTaskUid().equals(leaderUid)) {
                return partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderPartitionList.addAll(newPartitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).sharedPartitions(leaderSharedPartitionList).build();
    }

    private TaskState takeSharedPartitionsFromSurvivedTasks(TaskState leaderTaskState, Map<String, TaskState> survivedTasks) {
        Set<String> tokens = this.collectPartitionTokens(leaderTaskState);
        List partitions = this.filterDuplications(survivedTasks.values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).collect(Collectors.toList())).stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).filter(partitionState -> !survivedTasks.containsKey(partitionState.getAssigneeTaskUid())).map(partitionState -> partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build()).collect(Collectors.toList());
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        leaderPartitionList.addAll(partitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
    }

    private TaskState moveFinishedPartitionsFromObsoleteTasks(TaskState leaderTaskState, Map<String, TaskState> obsoleteTasks) {
        Set<String> tokens = this.collectPartitionTokens(leaderTaskState);
        ArrayList<PartitionState> leaderPartitionList = new ArrayList<PartitionState>(leaderTaskState.getPartitions());
        List<PartitionState> allPartitions = this.filterDuplications(obsoleteTasks.values().stream().flatMap(taskState -> taskState.getPartitions().stream()).collect(Collectors.toList()));
        List finishedPartitions = allPartitions.stream().filter(partitionState -> !tokens.contains(partitionState.getToken())).map(partitionState -> {
            if (PartitionStateEnum.FINISHED.equals((Object)partitionState.getState())) {
                return partitionState.toBuilder().assigneeTaskUid(leaderTaskState.getTaskUid()).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        leaderPartitionList.addAll(finishedPartitions);
        return leaderTaskState.toBuilder().partitions(leaderPartitionList).build();
    }

    private List<PartitionState> filterDuplications(List<PartitionState> partitionStates) {
        return partitionStates.stream().collect(Collectors.groupingBy(PartitionState::getToken)).values().stream().flatMap(list -> list.stream().sorted().limit(1L)).collect(Collectors.toList());
    }

    private Set<String> collectPartitionTokens(TaskState taskState) {
        return Stream.concat(taskState.getPartitionsMap().keySet().stream(), taskState.getSharedPartitionsMap().keySet().stream()).collect(Collectors.toSet());
    }
}

