/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.kafka.internal.TaskSyncEventListener;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.scaler.TaskScaler;
import io.debezium.connector.spanner.task.scaler.TaskScalerMonitor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskScalerMonitorImpl
implements TaskScalerMonitor {
    private final TaskSyncEventListener taskSyncEventListener;
    private final TaskScaler taskScaler;
    private final CountDownLatch initialLatch;
    private final AtomicInteger requiredTasksCount;
    private final int minTasks;

    public TaskScalerMonitorImpl(TaskSyncEventListener taskSyncEventListener, TaskScaler taskScaler, int minTasks) {
        this.taskSyncEventListener = taskSyncEventListener;
        this.taskScaler = taskScaler;
        this.requiredTasksCount = new AtomicInteger();
        this.initialLatch = new CountDownLatch(1);
        this.minTasks = minTasks;
    }

    @Override
    public int start() throws InterruptedException {
        this.taskSyncEventListener.subscribe((taskSyncEvent, ready) -> {
            if (this.initialLatch.getCount() > 0L) {
                this.requiredTasksCount.set(this.taskScaler.getTasksCount((TaskSyncEvent)taskSyncEvent, this.minTasks));
                this.initialLatch.countDown();
            } else if (taskSyncEvent.getMessageType() == MessageTypeEnum.UPDATE_EPOCH) {
                this.requiredTasksCount.set(this.taskScaler.ensureTasksScale((TaskSyncEvent)taskSyncEvent));
            }
        });
        this.taskSyncEventListener.start();
        this.initialLatch.await();
        return this.requiredTasksCount.get();
    }

    @Override
    public int getRequiredTasksCount() {
        return this.requiredTasksCount.get();
    }

    @Override
    public void shutdown() {
        this.taskSyncEventListener.shutdown();
    }
}

