/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import binlogdata.Binlogdata;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Vgtid {
    public static final String CURRENT_GTID = "current";
    private static final Gson gson = new Gson();
    private final Binlogdata.VGtid rawVgtid;
    private final Set<ShardGtid> shardGtids = new HashSet<ShardGtid>();

    private Vgtid(Binlogdata.VGtid rawVgtid) {
        this.rawVgtid = rawVgtid;
        for (Binlogdata.ShardGtid shardGtid : rawVgtid.getShardGtidsList()) {
            this.shardGtids.add(new ShardGtid(shardGtid.getKeyspace(), shardGtid.getShard(), shardGtid.getGtid()));
        }
    }

    private Vgtid(List<ShardGtid> shardGtids) {
        this.shardGtids.addAll(shardGtids);
        Binlogdata.VGtid.Builder builder = Binlogdata.VGtid.newBuilder();
        for (ShardGtid shardGtid : shardGtids) {
            builder.addShardGtids(Binlogdata.ShardGtid.newBuilder().setKeyspace(shardGtid.getKeyspace()).setShard(shardGtid.getShard()).setGtid(shardGtid.getGtid()).build());
        }
        this.rawVgtid = builder.build();
    }

    public static Vgtid of(String shardGtidsInJson) {
        List shardGtids = (List)gson.fromJson(shardGtidsInJson, new TypeToken<List<ShardGtid>>(){}.getType());
        return Vgtid.of(shardGtids);
    }

    public static Vgtid of(Binlogdata.VGtid rawVgtid) {
        return new Vgtid(rawVgtid);
    }

    public static Vgtid of(List<ShardGtid> shardGtids) {
        return new Vgtid(shardGtids);
    }

    public Binlogdata.VGtid getRawVgtid() {
        return this.rawVgtid;
    }

    public Set<ShardGtid> getShardGtids() {
        return this.shardGtids;
    }

    public boolean isSingleShard() {
        return this.rawVgtid.getShardGtidsCount() == 1;
    }

    public String toString() {
        return gson.toJson(this.shardGtids);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vgtid vgtid = (Vgtid)o;
        return Objects.equals(this.rawVgtid, vgtid.rawVgtid) && Objects.equals(this.shardGtids, vgtid.shardGtids);
    }

    public int hashCode() {
        return Objects.hash(this.rawVgtid, this.shardGtids);
    }

    public static class ShardGtid {
        private final String keyspace;
        private final String shard;
        private final String gtid;

        public ShardGtid(String keyspace, String shard, String gtid) {
            this.keyspace = keyspace;
            this.shard = shard;
            this.gtid = gtid;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getShard() {
            return this.shard;
        }

        public String getGtid() {
            return this.gtid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardGtid shardGtid = (ShardGtid)o;
            return Objects.equals(this.keyspace, shardGtid.keyspace) && Objects.equals(this.shard, shardGtid.shard) && Objects.equals(this.gtid, shardGtid.gtid);
        }

        public int hashCode() {
            return Objects.hash(this.keyspace, this.shard, this.gtid);
        }
    }
}

