/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessDatabaseSchema;
import io.debezium.connector.vitess.VitessOffsetContext;
import io.debezium.connector.vitess.connection.ReplicationMessage;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VitessChangeRecordEmitter
extends RelationalChangeRecordEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessChangeRecordEmitter.class);
    private final ReplicationMessage message;
    private final VitessDatabaseSchema schema;
    private final VitessConnectorConfig connectorConfig;
    private final TableId tableId;

    public VitessChangeRecordEmitter(VitessOffsetContext offsetContext, Clock clock, VitessConnectorConfig connectorConfig, VitessDatabaseSchema schema, ReplicationMessage message) {
        super((OffsetContext)offsetContext, clock);
        this.schema = schema;
        this.message = message;
        this.connectorConfig = connectorConfig;
        this.tableId = VitessDatabaseSchema.parse(message.getTable());
        Objects.requireNonNull(this.tableId);
    }

    protected Envelope.Operation getOperation() {
        switch (this.message.getOperation()) {
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: {
                return Envelope.Operation.UPDATE;
            }
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + (Object)((Object)this.message.getOperation()));
    }

    protected Object[] getOldColumnValues() {
        switch (this.getOperation()) {
            case CREATE: {
                return null;
            }
        }
        return this.columnValues(this.message.getOldTupleList(), this.tableId);
    }

    protected Object[] getNewColumnValues() {
        switch (this.getOperation()) {
            case CREATE: 
            case UPDATE: {
                return this.columnValues(this.message.getNewTupleList(), this.tableId);
            }
        }
        return null;
    }

    private Object[] columnValues(List<ReplicationMessage.Column> columns, TableId tableId) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        Table table = this.schema.tableFor(tableId);
        Objects.requireNonNull(table);
        Object[] values = new Object[columns.size()];
        for (ReplicationMessage.Column column : columns) {
            String columnName = Strings.unquoteIdentifierPart((String)column.getName());
            int position = this.getPosition(columnName, table, values.length);
            if (position != -1) {
                Object value;
                values[position] = value = column.getValue(this.connectorConfig.includeUnknownDatatypes());
                continue;
            }
            LOGGER.error("Can not find position for {} in {}", (Object)columnName, (Object)table);
        }
        return values;
    }

    private int getPosition(String columnName, Table table, int maxPosition) {
        Column tableColumn = table.columnWithName(columnName);
        if (tableColumn == null) {
            LOGGER.warn("Internal schema is out-of-sync with incoming decoder events; column {} will be omitted from the change event.", (Object)columnName);
            return -1;
        }
        int position = tableColumn.position() - 1;
        if (position < 0 || position >= maxPosition) {
            LOGGER.warn("Internal schema is out-of-sync with incoming decoder events; column {} will be omitted from the change event.", (Object)columnName);
            return -1;
        }
        return position;
    }
}

