/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.VitessSourceInfoStructMaker;
import io.debezium.connector.vitess.connection.VtctldConnection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class VitessConnectorConfig
extends RelationalDatabaseConnectorConfig {
    private static final String VITESS_CONFIG_GROUP_PREFIX = "vitess.";
    private static final int DEFAULT_VTGATE_PORT = 15991;
    private static final int DEFAULT_VTCTLD_PORT = 15999;
    public static final Field VTGATE_HOST = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Vitess database hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Vitess database port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(15991).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Vitess VTGate gRPC server.");
    public static final Field VTGATE_USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field VTGATE_PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the user to be used when connecting the Vitess VTGate gRPC server.");
    public static final Field KEYSPACE = Field.create((String)"vitess.keyspace").withDisplayName("Keyspace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Vitess Keyspace is equivalent to MySQL database (a.k.a schema). E.p. \"commerce\"");
    public static final Field SHARD = Field.create((String)"vitess.shard").withDisplayName("Shard").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Single shard of which keyspace to read data from.E.p. \"0\" for an unsharded keyspace. Or \"-80\" for the -80 shard of the sharded keyspace.");
    public static final Field VTCTLD_HOST = Field.create((String)"vitess.vtctld.host").withDisplayName("VTGate server hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("VTCtld gRPC server host name. E.p. \"localhost\".");
    public static final Field VTCTLD_PORT = Field.create((String)"vitess.vtctld.port").withDisplayName("VTGate server port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(15999).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("VTCtld gRPC server port. E.p. \"15999\".");
    public static final Field VTCTLD_USER = Field.create((String)"vitess.vtctld.user").withDisplayName("VTCtld User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the user to be used when connecting the Vitess VTCtld gRPC server.");
    public static final Field VTCTLD_PASSWORD = Field.create((String)"vitess.vtctld.password").withDisplayName("VTCtld Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the user to be used when connecting the Vitess VTCtld gRPC server.");
    public static final Field TABLET_TYPE = Field.create((String)"vitess.tablet.type").withDisplayName("Tablet type to get data-changes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(VtctldConnection.TabletType.MASTER.name()).withDescription("Tablet type used to get latest vgtid from Vtctld and get data-changes from Vtgate. Value can be MASTER, REPLICA, and RDONLY.");
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create((String)"include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Vitess").type(new Field[]{KEYSPACE, SHARD, VTGATE_HOST, VTGATE_PORT, VTGATE_USER, VTGATE_PASSWORD, VTCTLD_HOST, VTCTLD_PORT, VTCTLD_USER, VTCTLD_PASSWORD, TABLET_TYPE}).events(new Field[]{INCLUDE_UNKNOWN_DATATYPES}).excluding(new Field[]{SCHEMA_EXCLUDE_LIST, SCHEMA_INCLUDE_LIST, PROVIDE_TRANSACTION_METADATA}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public VitessConnectorConfig(Configuration config) {
        super(config, config.getString(SERVER_NAME), null, x -> x.schema() + "." + x.table(), -1, ColumnFilterMode.CATALOG);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new VitessSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getKeyspace() {
        return this.getConfig().getString(KEYSPACE);
    }

    public String getShard() {
        return this.getConfig().getString(SHARD);
    }

    public String getVtgateHost() {
        return this.getConfig().getString(VTGATE_HOST);
    }

    public int getVtgatePort() {
        return this.getConfig().getInteger(VTGATE_PORT);
    }

    public String getVtgateUsername() {
        return this.getConfig().getString(VTGATE_USER);
    }

    public String getVtgatePassword() {
        return this.getConfig().getString(VTGATE_PASSWORD);
    }

    public String getVtctldHost() {
        return this.getConfig().getString(VTCTLD_HOST);
    }

    public int getVtctldPort() {
        return this.getConfig().getInteger(VTCTLD_PORT);
    }

    public String getVtctldUsername() {
        return this.getConfig().getString(VTCTLD_USER);
    }

    public String getVtctldPassword() {
        return this.getConfig().getString(VTCTLD_PASSWORD);
    }

    public String getTabletType() {
        return this.getConfig().getString(TABLET_TYPE);
    }

    public boolean includeUnknownDatatypes() {
        return this.getConfig().getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }
}

