/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.vitess.Filters;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.VitessChangeEventSourceFactory;
import io.debezium.connector.vitess.VitessConnector;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessDatabaseSchema;
import io.debezium.connector.vitess.VitessEventMetadataProvider;
import io.debezium.connector.vitess.VitessOffsetContext;
import io.debezium.connector.vitess.VitessTaskContext;
import io.debezium.connector.vitess.VitessTopicSelector;
import io.debezium.connector.vitess.connection.ReplicationConnection;
import io.debezium.connector.vitess.connection.VitessReplicationConnection;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.SchemaNameAdjuster;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessConnectorTask
extends BaseSourceTask<VitessOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessConnectorTask.class);
    private static final String CONTEXT_NAME = "vitess-connector-task";
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile ErrorHandler errorHandler;
    private volatile VitessDatabaseSchema schema;
    private volatile ReplicationConnection replicationConnection;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeEventSourceCoordinator<VitessOffsetContext> start(Configuration config) {
        VitessConnectorConfig connectorConfig = new VitessConnectorConfig(config);
        TopicSelector<TableId> topicSelector = VitessTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        this.schema = new VitessDatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector);
        VitessTaskContext taskContext = new VitessTaskContext(connectorConfig, this.schema);
        VitessOffsetContext previousOffset = (VitessOffsetContext)this.getPreviousOffset(new VitessOffsetContext.Loader(connectorConfig));
        Clock clock = Clock.system();
        LoggingContext.PreviousContext previousContext = taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
            } else {
                LOGGER.info("Found previous offset {}", (Object)previousOffset);
            }
            this.replicationConnection = new VitessReplicationConnection(connectorConfig, this.schema);
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new ErrorHandler(VitessConnector.class, connectorConfig.getLogicalName(), this.queue);
            VitessEventMetadataProvider metadataProvider = new VitessEventMetadataProvider();
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)new Filters(connectorConfig).tableFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster);
            ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator((OffsetContext)previousOffset, this.errorHandler, VitessConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new VitessChangeEventSourceFactory(connectorConfig, this.errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema, this.replicationConnection), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema);
            coordinator.start((CdcSourceTaskContext)taskContext, this.queue, (EventMetadataProvider)metadataProvider);
            ChangeEventSourceCoordinator changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousContext.restore();
        }
    }

    protected List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return VitessConnectorConfig.ALL_FIELDS;
    }
}

