/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.data.Enum;
import io.debezium.data.EnumSet;
import io.debezium.data.Json;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.vitess.proto.Query;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;

public class VitessValueConverter
extends JdbcValueConverters {
    private final boolean includeUnknownDatatypes;

    public VitessValueConverter(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, ZoneOffset defaultOffset, boolean includeUnknownDatatypes) {
        super(decimalMode, temporalPrecisionMode, defaultOffset, null, null, null);
        this.includeUnknownDatatypes = includeUnknownDatatypes;
    }

    public SchemaBuilder schemaBuilder(Column column) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, Query.Type.JSON.name())) {
            return Json.builder();
        }
        if (this.matches(typeName, Query.Type.ENUM.name())) {
            return Enum.builder((List)column.enumValues());
        }
        if (this.matches(typeName, Query.Type.SET.name())) {
            return EnumSet.builder((List)column.enumValues());
        }
        SchemaBuilder jdbcSchemaBuilder = super.schemaBuilder(column);
        if (jdbcSchemaBuilder == null) {
            return this.includeUnknownDatatypes ? SchemaBuilder.bytes() : null;
        }
        return jdbcSchemaBuilder;
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        String typeName = column.typeName().toUpperCase();
        if (this.matches(typeName, Query.Type.ENUM.name())) {
            return data -> this.convertEnumToString(column.enumValues(), column, fieldDefn, data);
        }
        if (this.matches(typeName, Query.Type.SET.name())) {
            return data -> this.convertSetToString(column.enumValues(), column, fieldDefn, data);
        }
        ValueConverter jdbcConverter = super.converter(column, fieldDefn);
        if (jdbcConverter == null) {
            return this.includeUnknownDatatypes ? data -> this.convertBinary(column, fieldDefn, data, this.binaryMode) : null;
        }
        return jdbcConverter;
    }

    protected boolean matches(String upperCaseTypeName, String upperCaseMatch) {
        if (upperCaseTypeName == null) {
            return false;
        }
        return upperCaseMatch.equals(upperCaseTypeName) || upperCaseTypeName.startsWith(upperCaseMatch + "(");
    }

    private Object convertEnumToString(List<String> options, Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (options != null) {
                int value = (Integer)data;
                if (value == 0) {
                    r.deliver((Object)"");
                } else {
                    int index = value - 1;
                    if (index < options.size() && index >= 0) {
                        r.deliver(options.get(index));
                    } else {
                        r.deliver((Object)"");
                    }
                }
            } else {
                r.deliver((Object)"");
            }
        });
    }

    protected Object convertSetToString(List<String> options, Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            long indexes = (Long)data;
            r.deliver((Object)this.convertSetValue(column, indexes, options));
        });
    }

    protected String convertSetValue(Column column, long indexes, List<String> options) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        boolean first = true;
        int optionLen = options.size();
        while (indexes != 0L) {
            if (indexes % 2L != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (index < optionLen) {
                    sb.append(options.get(index));
                } else {
                    this.logger.warn("Found unexpected index '{}' on column {}", (Object)index, (Object)column);
                }
            }
            ++index;
            indexes >>>= 1;
        }
        return sb.toString();
    }
}

