/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import io.debezium.connector.vitess.VitessType;
import io.debezium.connector.vitess.connection.ReplicationMessage;
import io.debezium.connector.vitess.connection.ReplicationMessageColumnValueResolver;
import io.debezium.connector.vitess.connection.VitessColumnValue;

public class ReplicationMessageColumn
implements ReplicationMessage.Column {
    private final String columnName;
    private final VitessType type;
    private final boolean optional;
    private final String rawValue;

    public ReplicationMessageColumn(String columnName, VitessType type, boolean optional, String rawValue) {
        this.columnName = columnName;
        this.type = type;
        this.optional = optional;
        this.rawValue = rawValue;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public VitessType getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Object getValue(boolean includeUnknownDatatypes) {
        VitessColumnValue columnValue = new VitessColumnValue(this.rawValue);
        return ReplicationMessageColumnValueResolver.resolveValue(this.type, columnValue, includeUnknownDatatypes);
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String toString() {
        return this.columnName + "=" + this.rawValue;
    }
}

