/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import io.debezium.connector.vitess.VitessType;
import io.debezium.connector.vitess.connection.ReplicationMessage;
import io.vitess.proto.Query;

public class ReplicationMessageColumnValueResolver {
    public static Object resolveValue(VitessType vitessType, ReplicationMessage.ColumnValue value, boolean includeUnknownDatatypes) {
        if (value.isNull()) {
            return null;
        }
        switch (vitessType.getJdbcId()) {
            case 5: {
                return value.asShort();
            }
            case 4: {
                return value.asInteger();
            }
            case -5: {
                if (vitessType.getName().equals(Query.Type.UINT64.name())) {
                    return Long.parseUnsignedLong(value.asString());
                }
                return value.asLong();
            }
            case 12: {
                return value.asString();
            }
            case 6: {
                return value.asFloat();
            }
            case 8: {
                return value.asDouble();
            }
        }
        return value.asDefault(vitessType, includeUnknownDatatypes);
    }
}

