/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import io.debezium.connector.vitess.VitessType;
import io.debezium.connector.vitess.connection.ReplicationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessColumnValue
implements ReplicationMessage.ColumnValue<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessColumnValue.class);
    private final String value;

    public VitessColumnValue(String value) {
        this.value = value;
    }

    @Override
    public String getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Integer asInteger() {
        return Integer.valueOf(this.value);
    }

    @Override
    public Short asShort() {
        return Short.valueOf(this.value);
    }

    @Override
    public Long asLong() {
        return Long.valueOf(this.value);
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.value);
    }

    @Override
    public Double asDouble() {
        return Double.valueOf(this.value);
    }

    @Override
    public Object asDefault(VitessType vitessType, boolean includeUnknownDatatypes) {
        if (includeUnknownDatatypes) {
            LOGGER.warn("process unknown column type {} as string", (Object)vitessType);
            return this.asString();
        }
        LOGGER.warn("ignore unknown column type {}", (Object)vitessType);
        return null;
    }
}

