/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import binlogdata.Binlogdata;
import io.debezium.connector.vitess.Vgtid;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.vitess.client.grpc.StaticAuthCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import logutil.Logutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vtctldata.Vtctldata;
import vtctlservice.VtctlGrpc;

public class VtctldConnection
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VtctldConnection.class);
    private static final int SHARD_GTID_INDEX = 8;
    private static final String VSCHEMA_FLAG = "vschema";
    private final String vtctldHost;
    private final int vtctldPort;
    private final String vtctldUsername;
    private final String vtctldPassword;
    private final ManagedChannel managedChannel;

    private VtctldConnection(String vtctldHost, int vtctldPort, String vtctldUsername, String vtctldPassword) {
        this.vtctldHost = vtctldHost;
        this.vtctldPort = vtctldPort;
        this.vtctldUsername = vtctldUsername;
        this.vtctldPassword = vtctldPassword;
        this.managedChannel = ManagedChannelBuilder.forAddress((String)vtctldHost, (int)vtctldPort).usePlaintext().build();
    }

    public static VtctldConnection of(String vtctldHost, int vtctldPort, String vtctldUsername, String vtctldPassword) {
        return new VtctldConnection(vtctldHost, vtctldPort, vtctldUsername, vtctldPassword);
    }

    public Vgtid latestVgtid(String keyspace, String shard, TabletType tabletType) {
        String command = "ShardReplicationPositions";
        List<String> args = Arrays.asList(command, keyspace + ":" + shard);
        List<String> results = this.execVtctl(args, this.vtctldHost, this.vtctldPort);
        LOGGER.info("Get the latest replication positions of a specific keyspace {} shard {}: {}", new Object[]{keyspace, shard, results});
        String shardGtid = this.chooseShardGtid(results, tabletType);
        LOGGER.info("Choose ShardGtid: {}" + shardGtid);
        return Vgtid.of(Binlogdata.VGtid.newBuilder().addShardGtids(Binlogdata.ShardGtid.newBuilder().setKeyspace(keyspace).setShard(shard).setGtid(shardGtid).build()).build());
    }

    public void applyVSchema(String vschema, String keyspace) {
        String command = "ApplyVSchema";
        List<String> args = Arrays.asList(command, "-vschema=" + vschema, keyspace);
        List<String> results = this.execVtctl(args, this.vtctldHost, this.vtctldPort);
        LOGGER.info("Vschema {} is applied. Result: {}", (Object)vschema, results);
    }

    private String chooseShardGtid(List<String> results, TabletType tabletType) {
        int tabletTypeIdx = 0;
        switch (tabletType) {
            case MASTER: {
                tabletTypeIdx = 0;
                break;
            }
            case REPLICA: {
                tabletTypeIdx = 1;
                break;
            }
            case RDONLY: {
                tabletTypeIdx = 2;
            }
        }
        return results.get(tabletTypeIdx).split(" ")[8];
    }

    private List<String> execVtctl(List<String> args, String vtctldHost, int vtctldPort) {
        ArrayList<String> res = new ArrayList<String>();
        VtctlGrpc.VtctlBlockingStub stub = VtctlGrpc.newBlockingStub((Channel)this.managedChannel);
        if (this.vtctldUsername != null && this.vtctldPassword != null) {
            LOGGER.info("Use authenticated vtctld grpc.");
            stub = (VtctlGrpc.VtctlBlockingStub)stub.withCallCredentials((CallCredentials)new StaticAuthCredentials(this.vtctldUsername, this.vtctldPassword));
        }
        Iterator responseIter = stub.executeVtctlCommand(Vtctldata.ExecuteVtctlCommandRequest.newBuilder().setActionTimeout(10000000000L).addAllArgs(args).build());
        while (responseIter.hasNext()) {
            Vtctldata.ExecuteVtctlCommandResponse response = (Vtctldata.ExecuteVtctlCommandResponse)responseIter.next();
            Logutil.Event event = response.getEvent();
            if (!Logutil.Level.CONSOLE.equals((Object)event.getLevel())) continue;
            res.add(event.getValue());
        }
        return res;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("Closing VTCtld connection");
        this.managedChannel.shutdownNow();
        LOGGER.trace("VTCtld GRPC channel shutdownNow is invoked.");
        if (this.managedChannel.awaitTermination(5L, TimeUnit.SECONDS)) {
            LOGGER.info("VTCtld GRPC channel is shutdown in time.");
        } else {
            LOGGER.warn("VTCtld GRPC channel is not shutdown in time. Give up waiting.");
        }
    }

    public static enum TabletType {
        MASTER,
        REPLICA,
        RDONLY;

    }
}

