/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class Predicates {
    private static final Pattern LITERAL_SEPARATOR_PATTERN = Pattern.compile(",");

    public static Predicate<String> includesUuids(String uuidPatterns) {
        return Predicates.includesLiteralsOrPatterns(uuidPatterns, Strings::isUuid, s -> s);
    }

    public static Predicate<String> excludesUuids(String uuidPatterns) {
        return Predicates.includesUuids(uuidPatterns).negate();
    }

    public static <T> Predicate<T> includesLiteralsOrPatterns(String literalsOrPatterns, Predicate<String> isLiteral, Function<T, String> conversion) {
        HashSet<String> literals = new HashSet<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String literalOrPattern : LITERAL_SEPARATOR_PATTERN.split(literalsOrPatterns)) {
            if (isLiteral.test(literalOrPattern)) {
                literals.add(literalOrPattern.toLowerCase());
                continue;
            }
            patterns.add(Pattern.compile(literalOrPattern, 2));
        }
        Predicate<T> patternsPredicate = Predicates.includedInPatterns(patterns, conversion);
        Predicate<T> literalsPredicate = Predicates.includedInLiterals(literals, conversion);
        if (patterns.isEmpty()) {
            return literalsPredicate;
        }
        if (literals.isEmpty()) {
            return patternsPredicate;
        }
        return literalsPredicate.or(patternsPredicate);
    }

    public static <T> Predicate<T> excludesLiteralsOrPatterns(String patterns, Predicate<String> isLiteral, Function<T, String> conversion) {
        return Predicates.includesLiteralsOrPatterns(patterns, isLiteral, conversion).negate();
    }

    public static Predicate<String> includesLiterals(String literals) {
        return Predicates.includesLiterals(literals, s -> s);
    }

    public static Predicate<String> excludesLiterals(String literals) {
        return Predicates.includesLiterals(literals).negate();
    }

    public static <T> Predicate<T> includesLiterals(String literals, Function<T, String> conversion) {
        String[] literalValues = LITERAL_SEPARATOR_PATTERN.split(literals.toLowerCase());
        HashSet<String> literalSet = new HashSet<String>(Arrays.asList(literalValues));
        return Predicates.includedInLiterals(literalSet, conversion);
    }

    public static <T> Predicate<T> excludesLiterals(String literals, Function<T, String> conversion) {
        return Predicates.includesLiterals(literals, conversion).negate();
    }

    public static Predicate<String> includes(String regexPatterns) {
        return Predicates.includes(regexPatterns, str -> str);
    }

    public static Predicate<String> excludes(String regexPatterns) {
        return Predicates.includes(regexPatterns).negate();
    }

    public static <T> Predicate<T> includes(String regexPatterns, Function<T, String> conversion) {
        Set<Pattern> patterns = Strings.listOfRegex(regexPatterns, 2);
        return Predicates.includedInPatterns(patterns, conversion);
    }

    protected static <T> Predicate<T> includedInPatterns(Collection<Pattern> patterns, Function<T, String> conversion) {
        return t -> {
            String str = (String)conversion.apply(t);
            if (str != null) {
                for (Pattern p : patterns) {
                    if (!p.matcher(str).matches()) continue;
                    return true;
                }
            }
            return false;
        };
    }

    protected static <T> Predicate<T> includedInLiterals(Collection<String> literals, Function<T, String> conversion) {
        return s -> {
            String str = ((String)conversion.apply(s)).toLowerCase();
            return literals.contains(str);
        };
    }

    public static <T> Predicate<T> excludes(String regexPatterns, Function<T, String> conversion) {
        return Predicates.includes(regexPatterns, conversion).negate();
    }

    public static <T> Predicate<T> filter(Predicate<T> allowed, Predicate<T> disallowed) {
        return allowed != null ? allowed : (disallowed != null ? disallowed : id -> true);
    }

    public static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> notNull() {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return t != null;
            }
        };
    }

    private Predicates() {
    }
}

