/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

public class Threads {
    public static TimeSince timeSince(final Clock clock) {
        return new TimeSince(){
            private long lastTimeInMillis;

            @Override
            public void reset() {
                this.lastTimeInMillis = clock.currentTimeInMillis();
            }

            @Override
            public long elapsedTime() {
                long elapsed = clock.currentTimeInMillis() - this.lastTimeInMillis;
                return elapsed <= 0L ? 0L : elapsed;
            }
        };
    }

    public static Thread interruptAfterTimeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer) {
        Thread threadToInterrupt = Thread.currentThread();
        return Threads.interruptAfterTimeout(threadName, timeout, timeoutUnit, elapsedTimer, threadToInterrupt);
    }

    public static Thread interruptAfterTimeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer, Thread threadToInterrupt) {
        return Threads.timeout(threadName, timeout, timeoutUnit, 100L, TimeUnit.MILLISECONDS, elapsedTimer::elapsedTime, elapsedTimer::reset, () -> threadToInterrupt.interrupt());
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, TimeSince elapsedTimer, Runnable uponTimeout) {
        return Threads.timeout(threadName, timeout, timeoutUnit, 100L, TimeUnit.MILLISECONDS, elapsedTimer::elapsedTime, elapsedTimer::reset, uponTimeout);
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, long sleepInterval, TimeUnit sleepUnit, TimeSince elapsedTimer, Runnable uponTimeout) {
        return Threads.timeout(threadName, timeout, timeoutUnit, sleepInterval, sleepUnit, elapsedTimer::elapsedTime, elapsedTimer::reset, uponTimeout);
    }

    public static Thread timeout(String threadName, long timeout, TimeUnit timeoutUnit, long sleepInterval, TimeUnit sleepUnit, LongSupplier elapsedTime, Runnable uponStart, Runnable uponTimeout) {
        long timeoutInMillis = timeoutUnit.toMillis(timeout);
        long sleepTimeInMillis = sleepUnit.toMillis(sleepInterval);
        Runnable r = () -> {
            if (uponStart != null) {
                uponStart.run();
            }
            while (elapsedTime.getAsLong() < timeoutInMillis) {
                try {
                    Thread.sleep(sleepTimeInMillis);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return;
                }
            }
            uponTimeout.run();
        };
        return new Thread(r, threadName);
    }

    private Threads() {
    }

    public static interface TimeSince {
        public void reset();

        public long elapsedTime();
    }
}

