/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class SchemaChangeHistory {
    private final String topicName;
    private final List<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
    private final Map<String, List<SourceRecord>> sourceRecordsByDbName = new HashMap<String, List<SourceRecord>>();

    public SchemaChangeHistory(String topic) {
        this.topicName = topic;
    }

    public boolean add(SourceRecord record) {
        if (this.topicName.equals(record.topic())) {
            this.sourceRecords.add(record);
            String dbName = this.getAffectedDatabase(record);
            this.sourceRecordsByDbName.computeIfAbsent(dbName, db -> new ArrayList()).add(record);
            return true;
        }
        return false;
    }

    public int recordCount() {
        return this.sourceRecords.size();
    }

    public void forEach(Consumer<SourceRecord> consumer) {
        this.sourceRecords.forEach(consumer);
    }

    public int databaseCount() {
        return this.sourceRecordsByDbName.size();
    }

    public Set<String> databases() {
        return Collections.unmodifiableSet(this.sourceRecordsByDbName.keySet());
    }

    public List<SourceRecord> ddlRecordsForDatabase(String dbName) {
        return this.sourceRecordsByDbName.get(dbName);
    }

    protected String getAffectedDatabase(SourceRecord record) {
        Struct envelope = (Struct)record.value();
        Field dbField = envelope.schema().field("databaseName");
        if (dbField != null) {
            return envelope.getString(dbField.name());
        }
        return null;
    }
}

