/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.ColumnId;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import java.util.function.Predicate;

public abstract class HistorizedRelationalDatabaseSchema
extends RelationalDatabaseSchema
implements HistorizedDatabaseSchema<TableId> {
    private final DatabaseHistory databaseHistory;

    protected HistorizedRelationalDatabaseSchema(HistorizedRelationalDatabaseConnectorConfig config, TopicSelector<TableId> topicSelector, Tables.TableFilter tableFilter, Predicate<ColumnId> columnFilter, TableSchemaBuilder schemaBuilder, boolean tableIdCaseInsensitive) {
        super(config, topicSelector, tableFilter, columnFilter, schemaBuilder, tableIdCaseInsensitive);
        this.databaseHistory = config.getDatabaseHistory();
        this.databaseHistory.start();
    }

    @Override
    public void recover(OffsetContext offset) {
        this.databaseHistory.recover(offset.getPartition(), offset.getOffset(), this.tables(), this.getDdlParser());
        for (TableId tableId : this.tableIds()) {
            this.buildAndRegisterSchema(this.tableFor(tableId));
        }
    }

    @Override
    public void close() {
        this.databaseHistory.stop();
    }

    @Override
    public void initializeStorage() {
        if (!this.databaseHistory.exists()) {
            this.databaseHistory.initializeStorage();
        }
    }

    protected abstract DdlParser getDdlParser();

    protected void record(SchemaChangeEvent schemaChange, TableChanges tableChanges) {
        this.databaseHistory.record(schemaChange.getPartition(), schemaChange.getOffset(), schemaChange.getDatabase(), schemaChange.getSchema(), schemaChange.getDdl(), tableChanges);
    }
}

