/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlTokenizer;
import io.debezium.text.TokenStream;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class DataTypeParserTest {
    private DataTypeParser parser;

    @Before
    public void beforeEach() {
        this.parser = new DataTypeParser();
        this.parser.register(16, "BOOL");
        this.parser.register(16, "BOOLEAN");
        this.parser.register(16, "BIT[(1)]");
        this.parser.register(16, "TINYINT(1)");
        this.parser.register(-7, "BIT(M)");
        this.parser.register(4, "TINYINT[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(4, "SMALLINT[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(4, "MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(4, "INT[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(4, "INTEGER[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(-5, "BIGINT[(M)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(3, "DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]");
        this.parser.register(3, "DEC[(M[,D])] [UNSIGNED] [ZEROFILL]");
        this.parser.register(3, "NUMERIC[(M[,D])] [UNSIGNED] [ZEROFILL]");
        this.parser.register(3, "FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]");
        this.parser.register(6, "FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(8, "DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(8, "DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(8, "REAL[(M,D)] [UNSIGNED] [ZEROFILL]");
        this.parser.register(1, "ENUM(...) [CHARSET charset_name] [COLLATE collation_name]");
        this.parser.register(12, "VARCHAR");
    }

    @Test
    public void shouldDetermineBooleanTypes() {
        this.assertType("BIT(1)", "BIT", 16, 1L);
        this.assertType("BIT", "BIT", 16);
        this.assertType("BOOLEAN", "BOOLEAN", 16);
        this.assertType("BOOL", "BOOL", 16);
        this.assertType("TINYINT(1)", "TINYINT", 16, 1L);
        this.assertType("BIT(-3)", "BIT", 16);
        this.assertNoType("BOOLE");
    }

    @Test
    public void shouldDetermineBitTypes() {
        this.assertType("BIT(2)", "BIT", -7, 2L);
        this.assertType("BIT(3)", "BIT", -7, 3L);
    }

    @Test
    public void shouldDetermineIntegerTypes() {
        this.assertType("TINYINT", "TINYINT", 4);
        this.assertType("TINYINT(2)", "TINYINT", 4, 2L);
        this.assertType("TINYINT(10)", "TINYINT", 4, 10L);
        this.assertType("SMALLINT", "SMALLINT", 4);
        this.assertType("SMALLINT(2)", "SMALLINT", 4, 2L);
        this.assertType("SMALLINT(10)", "SMALLINT", 4, 10L);
        this.assertType("MEDIUMINT", "MEDIUMINT", 4);
        this.assertType("MEDIUMINT(2)", "MEDIUMINT", 4, 2L);
        this.assertType("MEDIUMINT(10)", "MEDIUMINT", 4, 10L);
        this.assertType("INT", "INT", 4);
        this.assertType("INT(2)", "INT", 4, 2L);
        this.assertType("INT(10)", "INT", 4, 10L);
        this.assertType("INTEGER", "INTEGER", 4);
        this.assertType("INTEGER(2)", "INTEGER", 4, 2L);
        this.assertType("INTEGER(10)", "INTEGER", 4, 10L);
        this.assertType("INTEGER(-2)", "INTEGER", 4);
    }

    @Test
    public void shouldDetermineBitIntegerTypes() {
        this.assertType("BIGINT", "BIGINT", -5);
        this.assertType("BIGINT(2)", "BIGINT", -5, 2L);
        this.assertType("BIGINT(10)", "BIGINT", -5, 10L);
    }

    @Test
    public void shouldDetermineDecimalTypes() {
        this.assertType("DECIMAL", "DECIMAL", 3);
        this.assertType("DECIMAL(2)", "DECIMAL", 3, 2L);
        this.assertType("DECIMAL(10)", "DECIMAL", 3, 10L);
        this.assertType("DECIMAL(2,1)", "DECIMAL", 3, 2L, 1);
        this.assertType("DECIMAL(10,5)", "DECIMAL", 3, 10L, 5);
        this.assertType("DECIMAL(10,5) ZEROFILL", "DECIMAL ZEROFILL", 3, 10L, 5);
        this.assertType("DECIMAL(10,5) UNSIGNED ZEROFILL", "DECIMAL UNSIGNED ZEROFILL", 3, 10L, 5);
    }

    @Test
    public void shouldDetermineTypeWithWildcard() {
        this.assertType("ENUM('a','b','c')", "ENUM", 1);
        this.assertEnumType("ENUM('a','multi','multi with () paren', 'other') followed by", "ENUM('a','multi','multi with () paren', 'other')");
    }

    protected void assertType(String content, String typeName, int jdbcType) {
        this.assertType(content, typeName, jdbcType, -1L, -1, null);
    }

    protected void assertType(String content, String typeName, int jdbcType, long length) {
        this.assertType(content, typeName, jdbcType, length, -1, null);
    }

    protected void assertType(String content, String typeName, int jdbcType, long precision, int scale) {
        this.assertType(content, typeName, jdbcType, precision, scale, null);
    }

    protected void assertType(String content, String typeName, int jdbcType, long length, int scale, int[] arrayDims) {
        DataType type = this.parser.parse(this.text(content), null);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((int)type.jdbcType()).isEqualTo(jdbcType);
        Assertions.assertThat((String)type.name()).isEqualTo((Object)typeName);
        Assertions.assertThat((long)type.length()).isEqualTo(length);
        Assertions.assertThat((int)type.scale()).isEqualTo(scale);
        Assertions.assertThat((int[])type.arrayDimensions()).isEqualTo(arrayDims);
    }

    protected void assertEnumType(String content, String expression) {
        DataType type = this.parser.parse(this.text(content), null);
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((int)type.jdbcType()).isEqualTo(1);
        Assertions.assertThat((String)type.name()).isEqualTo((Object)"ENUM");
        Assertions.assertThat((long)type.length()).isEqualTo(-1L);
        Assertions.assertThat((String)type.expression()).isEqualTo((Object)expression);
    }

    protected void assertNoType(String content) {
        DataType type = this.parser.parse(this.text(content), null);
        Assertions.assertThat((Object)type).isNull();
    }

    protected TokenStream text(String content) {
        return new TokenStream(content, (TokenStream.Tokenizer)new DdlTokenizer(true), false).start();
    }
}

