/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.util.Threads;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private final ChangeEventQueue<?> queue;
    private final Runnable onThrowable;
    private final AtomicReference<Throwable> producerThrowable;
    private final ExecutorService executor;

    public ErrorHandler(Class<? extends SourceConnector> connectorType, String logicalName, ChangeEventQueue<?> queue, Runnable onThrowable) {
        this.queue = queue;
        this.onThrowable = onThrowable;
        this.executor = Threads.newSingleThreadExecutor(connectorType, logicalName, "error-handler");
        this.producerThrowable = new AtomicReference();
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        LOGGER.error("Producer failure", producerThrowable);
        boolean first = this.producerThrowable.compareAndSet(null, producerThrowable);
        if (first) {
            this.queue.producerFailure(producerThrowable);
            this.executor.execute(() -> this.onThrowable.run());
        }
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    public void stop() throws InterruptedException {
        this.executor.shutdownNow();
        this.executor.awaitTermination(60L, TimeUnit.SECONDS);
    }
}

