/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.Key;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.util.SchemaNameAdjuster;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableSchemaBuilderTest {
    private static final String AVRO_UNSUPPORTED_NAME = "9-`~!@#$%^&*()+=[]{}\\|;:\"'<>,.?/";
    private static final String AVRO_UNSUPPORTED_NAME_CONVERTED = "_9_______________________________";
    private final String prefix = "";
    private final TableId id = new TableId("catalog", "schema", "table");
    private final Object[] data = new Object[]{"c1value", 3.142, Date.valueOf("2001-10-31"), 4, new byte[]{71, 117, 110, 110, 97, 114}, null, "c7value", "c8value", "c9value"};
    private final Object[] keyData = new Object[]{"c1value", 3.142};
    private Table table;
    private Column c1;
    private Column c2;
    private Column c3;
    private Column c4;
    private Column c5;
    private Column c6;
    private Column c7;
    private Column c8;
    private Column c9;
    private TableSchema schema;
    private SchemaNameAdjuster adjuster;
    private final CustomConverterRegistry customConverterRegistry = new CustomConverterRegistry(null);

    @Before
    public void beforeEach() {
        this.adjuster = SchemaNameAdjuster.create((original, replacement, conflict) -> Assert.fail((String)"Should not have come across an invalid schema name"));
        this.schema = null;
        this.table = Table.editor().tableId(this.id).addColumns(new Column[]{Column.editor().name("C1").type("VARCHAR").jdbcType(12).length(10).optional(false).generated(true).create(), Column.editor().name("C2").type("NUMBER").jdbcType(2).length(5).scale(Integer.valueOf(3)).create(), Column.editor().name("C3").type("DATE").jdbcType(91).length(4).optional(true).create(), Column.editor().name("C4").type("COUNTER").jdbcType(4).autoIncremented(true).optional(true).create(), Column.editor().name("C5").type("BINARY").jdbcType(-2).optional(false).length(16).create(), Column.editor().name("C6").type("SMALLINT").jdbcType(5).optional(false).length(1).create(), Column.editor().name("7C7").type("VARCHAR").jdbcType(12).length(10).optional(false).create(), Column.editor().name("C-8").type("VARCHAR").jdbcType(12).length(10).optional(false).create(), Column.editor().name(AVRO_UNSUPPORTED_NAME).type("VARCHAR").jdbcType(12).length(10).optional(false).create()}).setPrimaryKeyNames(new String[]{"C1", "C2"}).create();
        this.c1 = this.table.columnWithName("C1");
        this.c2 = this.table.columnWithName("C2");
        this.c3 = this.table.columnWithName("C3");
        this.c4 = this.table.columnWithName("C4");
        this.c5 = this.table.columnWithName("C5");
        this.c6 = this.table.columnWithName("C6");
        this.c7 = this.table.columnWithName("7C7");
        this.c8 = this.table.columnWithName("C-8");
        this.c9 = this.table.columnWithName(AVRO_UNSUPPORTED_NAME);
    }

    @Test
    public void checkPreconditions() {
        Assertions.assertThat((Object)this.c1).isNotNull();
        Assertions.assertThat((Object)this.c2).isNotNull();
        Assertions.assertThat((Object)this.c3).isNotNull();
        Assertions.assertThat((Object)this.c4).isNotNull();
        Assertions.assertThat((Object)this.c5).isNotNull();
        Assertions.assertThat((Object)this.c6).isNotNull();
        Assertions.assertThat((Object)this.c7).isNotNull();
        Assertions.assertThat((Object)this.c8).isNotNull();
        Assertions.assertThat((Object)this.c9).isNotNull();
    }

    @Test(expected=NullPointerException.class)
    public void shouldFailToBuildTableSchemaFromNullTable() {
        new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", null, null, null, null);
    }

    @Test
    public void shouldBuildTableSchemaFromTable() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
    }

    @Test
    @FixFor(value={"DBZ-1089"})
    public void shouldBuildCorrectSchemaNames() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((String)this.schema.keySchema().name()).isEqualTo((Object)"schema.table.Key");
        Assertions.assertThat((String)this.schema.valueSchema().name()).isEqualTo((Object)"schema.table.Value");
        this.table = this.table.edit().tableId(new TableId("testDb", null, "testTable")).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((String)this.schema.keySchema().name()).isEqualTo((Object)"testDb.testTable.Key");
        Assertions.assertThat((String)this.schema.valueSchema().name()).isEqualTo((Object)"testDb.testTable.Value");
        this.table = this.table.edit().tableId(new TableId(null, "testSchema", "testTable")).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((String)this.schema.keySchema().name()).isEqualTo((Object)"testSchema.testTable.Key");
        Assertions.assertThat((String)this.schema.valueSchema().name()).isEqualTo((Object)"testSchema.testTable.Value");
        this.table = this.table.edit().tableId(new TableId(null, null, "testTable")).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((String)this.schema.keySchema().name()).isEqualTo((Object)"testTable.Key");
        Assertions.assertThat((String)this.schema.valueSchema().name()).isEqualTo((Object)"testTable.Value");
    }

    @Test
    public void shouldBuildTableSchemaFromTableWithoutPrimaryKey() {
        this.table = this.table.edit().setPrimaryKeyNames(new String[0]).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((Object)this.schema.keySchema()).isNull();
        Assertions.assertThat((Object)this.schema.keyFromColumnData(this.data)).isNull();
        Schema values = this.schema.valueSchema();
        Assertions.assertThat((Object)values).isNotNull();
        Assertions.assertThat((String)values.field("C1").name()).isEqualTo((Object)"C1");
        Assertions.assertThat((int)values.field("C1").index()).isEqualTo(0);
        Assertions.assertThat((Object)values.field("C1").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((int)values.field("C2").index()).isEqualTo(1);
        Assertions.assertThat((Object)values.field("C2").schema()).isEqualTo((Object)Decimal.builder((int)3).parameter("connect.decimal.precision", "5").optional().build());
        Assertions.assertThat((String)values.field("C3").name()).isEqualTo((Object)"C3");
        Assertions.assertThat((int)values.field("C3").index()).isEqualTo(2);
        Assertions.assertThat((Object)values.field("C3").schema()).isEqualTo((Object)io.debezium.time.Date.builder().optional().build());
        Assertions.assertThat((String)values.field("C4").name()).isEqualTo((Object)"C4");
        Assertions.assertThat((int)values.field("C4").index()).isEqualTo(3);
        Assertions.assertThat((Object)values.field("C4").schema()).isEqualTo((Object)SchemaBuilder.int32().optional().build());
        Assertions.assertThat((int)values.field("C5").index()).isEqualTo(4);
        Assertions.assertThat((Object)values.field("C5").schema()).isEqualTo((Object)SchemaBuilder.bytes().build());
        Assertions.assertThat((int)values.field("C6").index()).isEqualTo(5);
        Assertions.assertThat((Object)values.field("C6").schema()).isEqualTo((Object)SchemaBuilder.int16().build());
        Assertions.assertThat((String)values.field("7C7").name()).isEqualTo((Object)"7C7");
        Assertions.assertThat((int)values.field("7C7").index()).isEqualTo(6);
        Assertions.assertThat((Object)values.field("7C7").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field("C-8").name()).isEqualTo((Object)"C-8");
        Assertions.assertThat((int)values.field("C-8").index()).isEqualTo(7);
        Assertions.assertThat((Object)values.field("C-8").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field(AVRO_UNSUPPORTED_NAME).name()).isEqualTo((Object)AVRO_UNSUPPORTED_NAME);
        Assertions.assertThat((int)values.field(AVRO_UNSUPPORTED_NAME).index()).isEqualTo(8);
        Assertions.assertThat((Object)values.field(AVRO_UNSUPPORTED_NAME).schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Struct value = this.schema.valueFromColumnData(this.data);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Object)value.get("C1")).isEqualTo((Object)"c1value");
        Assertions.assertThat((Object)value.get("C2")).isEqualTo((Object)BigDecimal.valueOf(3.142));
        Assertions.assertThat((Object)value.get("C3")).isEqualTo((Object)11626);
        Assertions.assertThat((Object)value.get("C4")).isEqualTo((Object)4);
        Assertions.assertThat((Object)value.get("C5")).isEqualTo((Object)ByteBuffer.wrap(new byte[]{71, 117, 110, 110, 97, 114}));
        Assertions.assertThat((Object)value.get("C6")).isEqualTo((Object)0);
    }

    @Test
    @FixFor(value={"DBZ-1044"})
    public void shouldSanitizeFieldNamesAndBuildTableSchemaFromTableWithoutPrimaryKey() {
        this.table = this.table.edit().setPrimaryKeyNames(new String[0]).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), true).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Assertions.assertThat((Object)this.schema.keySchema()).isNull();
        Assertions.assertThat((Object)this.schema.keyFromColumnData(this.data)).isNull();
        Schema values = this.schema.valueSchema();
        Assertions.assertThat((Object)values).isNotNull();
        Assertions.assertThat((String)values.field("C1").name()).isEqualTo((Object)"C1");
        Assertions.assertThat((int)values.field("C1").index()).isEqualTo(0);
        Assertions.assertThat((Object)values.field("C1").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((int)values.field("C2").index()).isEqualTo(1);
        Assertions.assertThat((Object)values.field("C2").schema()).isEqualTo((Object)Decimal.builder((int)3).parameter("connect.decimal.precision", "5").optional().build());
        Assertions.assertThat((String)values.field("C3").name()).isEqualTo((Object)"C3");
        Assertions.assertThat((int)values.field("C3").index()).isEqualTo(2);
        Assertions.assertThat((Object)values.field("C3").schema()).isEqualTo((Object)io.debezium.time.Date.builder().optional().build());
        Assertions.assertThat((String)values.field("C4").name()).isEqualTo((Object)"C4");
        Assertions.assertThat((int)values.field("C4").index()).isEqualTo(3);
        Assertions.assertThat((Object)values.field("C4").schema()).isEqualTo((Object)SchemaBuilder.int32().optional().build());
        Assertions.assertThat((int)values.field("C5").index()).isEqualTo(4);
        Assertions.assertThat((Object)values.field("C5").schema()).isEqualTo((Object)SchemaBuilder.bytes().build());
        Assertions.assertThat((int)values.field("C6").index()).isEqualTo(5);
        Assertions.assertThat((Object)values.field("C6").schema()).isEqualTo((Object)SchemaBuilder.int16().build());
        Assertions.assertThat((Object)values.field("7C7")).isNull();
        Assertions.assertThat((String)values.field("_7C7").name()).isEqualTo((Object)"_7C7");
        Assertions.assertThat((int)values.field("_7C7").index()).isEqualTo(6);
        Assertions.assertThat((Object)values.field("_7C7").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((Object)values.field("C-8")).isNull();
        Assertions.assertThat((String)values.field("C_8").name()).isEqualTo((Object)"C_8");
        Assertions.assertThat((int)values.field("C_8").index()).isEqualTo(7);
        Assertions.assertThat((Object)values.field("C_8").schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Assertions.assertThat((String)values.field(AVRO_UNSUPPORTED_NAME_CONVERTED).name()).isEqualTo((Object)AVRO_UNSUPPORTED_NAME_CONVERTED);
        Assertions.assertThat((int)values.field(AVRO_UNSUPPORTED_NAME_CONVERTED).index()).isEqualTo(8);
        Assertions.assertThat((Object)values.field(AVRO_UNSUPPORTED_NAME_CONVERTED).schema()).isEqualTo((Object)SchemaBuilder.string().build());
        Struct value = this.schema.valueFromColumnData(this.data);
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((Object)value.get("C1")).isEqualTo((Object)"c1value");
        Assertions.assertThat((Object)value.get("C2")).isEqualTo((Object)BigDecimal.valueOf(3.142));
        Assertions.assertThat((Object)value.get("C3")).isEqualTo((Object)11626);
        Assertions.assertThat((Object)value.get("C4")).isEqualTo((Object)4);
        Assertions.assertThat((Object)value.get("C5")).isEqualTo((Object)ByteBuffer.wrap(new byte[]{71, 117, 110, 110, 97, 114}));
        Assertions.assertThat((Object)value.get("C6")).isEqualTo((Object)0);
    }

    @Test
    @FixFor(value={"DBZ-1044"})
    public void shouldSanitizeFieldNamesAndValidateSerialization() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), true).create("", "sometopic", this.table, null, null, null);
        Struct key = (Struct)this.schema.keyFromColumnData(this.keyData);
        Struct value = this.schema.valueFromColumnData(this.data);
        SourceRecord record = new SourceRecord(Collections.emptyMap(), Collections.emptyMap(), "sometopic", this.schema.keySchema(), (Object)key, this.schema.valueSchema(), (Object)value);
        VerifyRecord.isValid(record);
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void shouldBuildTableSchemaFromTableWithCustomKey() {
        this.table = this.table.edit().setPrimaryKeyNames(new String[0]).create();
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, Key.CustomKeyMapper.getInstance((String)"(.*).table:C2,C3"));
        Assertions.assertThat((Object)this.schema).isNotNull();
        Schema keys = this.schema.keySchema();
        Assertions.assertThat((Object)keys).isNotNull();
        Assertions.assertThat((List)keys.fields()).hasSize(2);
        Assertions.assertThat((String)keys.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((String)keys.field("C3").name()).isEqualTo((Object)"C3");
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void shouldOverrideIdentityKey() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, Key.CustomKeyMapper.getInstance((String)"(.*).table:C2,C3"));
        Assertions.assertThat((Object)this.schema).isNotNull();
        Schema keys = this.schema.keySchema();
        Assertions.assertThat((Object)keys).isNotNull();
        Assertions.assertThat((List)keys.fields()).hasSize(2);
        Assertions.assertThat((Object)keys.field("C1")).isNull();
        Assertions.assertThat((String)keys.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((String)keys.field("C3").name()).isEqualTo((Object)"C3");
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void shouldFallbackToIdentyKeyWhenCustomMapperIsNull() {
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, null);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Schema keys = this.schema.keySchema();
        Assertions.assertThat((Object)keys).isNotNull();
        Assertions.assertThat((List)keys.fields()).hasSize(2);
        Assertions.assertThat((String)keys.field("C1").name()).isEqualTo((Object)"C1");
        Assertions.assertThat((String)keys.field("C2").name()).isEqualTo((Object)"C2");
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void customKeyMapperShouldMapMultipleTables() {
        TableId id2 = new TableId("catalog", "schema", "table2");
        Table table2 = Table.editor().tableId(id2).addColumns(new Column[]{Column.editor().name("C1").type("VARCHAR").jdbcType(12).length(10).optional(false).create(), Column.editor().name("C2").type("NUMBER").jdbcType(2).length(5).scale(Integer.valueOf(3)).create(), Column.editor().name("C3").type("DATE").jdbcType(91).length(4).optional(true).create()}).create();
        Key.KeyMapper keyMapper = Key.CustomKeyMapper.getInstance((String)"(.*).table:C2,C3;(.*).table2:C1");
        this.schema = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", this.table, null, null, keyMapper);
        Assertions.assertThat((Object)this.schema).isNotNull();
        Schema keys = this.schema.keySchema();
        Assertions.assertThat((Object)keys).isNotNull();
        Assertions.assertThat((List)keys.fields()).hasSize(2);
        Assertions.assertThat((Object)keys.field("C1")).isNull();
        Assertions.assertThat((String)keys.field("C2").name()).isEqualTo((Object)"C2");
        Assertions.assertThat((String)keys.field("C3").name()).isEqualTo((Object)"C3");
        TableSchema schema2 = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", table2, null, null, keyMapper);
        Assertions.assertThat((Object)schema2).isNotNull();
        Schema key2 = schema2.keySchema();
        Assertions.assertThat((Object)key2).isNotNull();
        Assertions.assertThat((List)key2.fields()).hasSize(1);
        Assertions.assertThat((String)key2.field("C1").name()).isEqualTo((Object)"C1");
    }

    @Test
    @FixFor(value={"DBZ-1507"})
    public void defaultKeyMapperShouldOrderKeyColumnsBasedOnPrimaryKeyColumnNamesOrder() {
        TableId id2 = new TableId("catalog", "schema", "info");
        Table table2 = Table.editor().tableId(id2).addColumns(new Column[]{Column.editor().name("t1ID").type("INT").jdbcType(4).optional(false).create(), Column.editor().name("t2ID").type("INT").jdbcType(4).optional(false).create()}).setPrimaryKeyNames(new String[]{"t2ID", "t1ID"}).create();
        TableSchema schema2 = new TableSchemaBuilder((ValueConverterProvider)new JdbcValueConverters(), this.adjuster, this.customConverterRegistry, SchemaBuilder.struct().build(), false).create("", "sometopic", table2, null, null, null);
        Schema key2 = schema2.keySchema();
        Assertions.assertThat((Object)key2).isNotNull();
        Assertions.assertThat((List)key2.fields()).hasSize(2);
        Assertions.assertThat((String)((Field)key2.fields().get(0)).name()).isEqualTo((Object)"t2ID");
        Assertions.assertThat((String)((Field)key2.fields().get(1)).name()).isEqualTo((Object)"t1ID");
    }
}

