/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.converters.ByteBufferConverter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ByteBufferConverterTest {
    private static final String TOPIC = "topic";
    private static final byte[] SAMPLE_BYTES = "sample string".getBytes(StandardCharsets.UTF_8);
    private ByteBufferConverter converter = new ByteBufferConverter();

    @Before
    public void setUp() {
        this.converter.configure(Collections.emptyMap(), false);
    }

    @Test
    public void shouldConvertFromConnectData() {
        byte[] bytes = this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap(SAMPLE_BYTES));
        Assertions.assertThat((byte[])bytes).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertFromConnectDataForOptionalBytesSchema() {
        byte[] bytes = this.converter.fromConnectData(TOPIC, Schema.OPTIONAL_BYTES_SCHEMA, (Object)ByteBuffer.wrap(SAMPLE_BYTES));
        Assertions.assertThat((byte[])bytes).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertFromConnectDataWithoutSchema() {
        byte[] bytes = this.converter.fromConnectData(TOPIC, null, (Object)ByteBuffer.wrap(SAMPLE_BYTES));
        Assertions.assertThat((byte[])bytes).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertNullFromConnectData() {
        byte[] bytes = this.converter.fromConnectData(TOPIC, null, null);
        Assertions.assertThat((byte[])bytes).isNull();
    }

    @Test
    public void shouldThrowWhenConvertNonByteSchemaFromConnectData() {
        try {
            this.converter.fromConnectData(TOPIC, Schema.BOOLEAN_SCHEMA, null);
            TestCase.fail((String)"now expected exception thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(DataException.class);
        }
    }

    @Test
    public void shouldThrowWhenConvertRawByteArrayFromConnectData() {
        try {
            this.converter.fromConnectData(TOPIC, Schema.BOOLEAN_SCHEMA, null);
            TestCase.fail((String)"now expected exception thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(DataException.class);
        }
    }

    @Test
    public void shouldConvertToConnectData() {
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, SAMPLE_BYTES);
        Assertions.assertThat((Object)schemaAndValue.schema()).isEqualTo((Object)Schema.OPTIONAL_BYTES_SCHEMA);
        Assertions.assertThat((Object)schemaAndValue.value()).isEqualTo((Object)ByteBuffer.wrap(SAMPLE_BYTES));
    }

    @Test
    public void shouldConvertToConnectDataForNullValue() {
        SchemaAndValue schemaAndValue = this.converter.toConnectData(TOPIC, null);
        Assertions.assertThat((Object)schemaAndValue.schema()).isEqualTo((Object)Schema.OPTIONAL_BYTES_SCHEMA);
        Assertions.assertThat((Object)schemaAndValue.value()).isNull();
    }
}

