/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterConfig;
import org.apache.kafka.connect.storage.HeaderConverter;

public class ByteBufferConverter
implements Converter,
HeaderConverter {
    private static final ConfigDef CONFIG_DEF = ConverterConfig.newConfigDef();

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void configure(Map<String, ?> configs) {
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        this.validateSchemaType(schema);
        this.validateValueType(value);
        return value == null ? null : ((ByteBuffer)value).array();
    }

    private void validateValueType(Object value) {
        if (value != null && !(value instanceof ByteBuffer)) {
            throw new DataException("ByteBufferConverter is not compatible with objects of type " + value.getClass());
        }
    }

    private void validateSchemaType(Schema schema) {
        if (schema != null && schema.type() != Schema.Type.BYTES) {
            throw new DataException("Invalid schema type for ByteBufferConverter: " + schema.type().toString());
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return new SchemaAndValue(Schema.OPTIONAL_BYTES_SCHEMA, (Object)(value == null ? null : ByteBuffer.wrap(value)));
    }

    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    public void close() {
    }
}

