/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.ThreadSafe;
import io.debezium.document.Document;
import io.debezium.document.JacksonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

@ThreadSafe
public interface DocumentWriter {
    public static DocumentWriter defaultWriter() {
        return JacksonWriter.INSTANCE;
    }

    public static DocumentWriter prettyWriter() {
        return JacksonWriter.PRETTY_WRITER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public byte[] writeAsBytes(Document document) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.write(document, stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public void write(Document var1, OutputStream var2) throws IOException;

    public void write(Document var1, Writer var2) throws IOException;

    public String write(Document var1) throws IOException;
}

