/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit.logging;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

public class LogInterceptor
extends AppenderSkeleton {
    private List<LoggingEvent> events = new CopyOnWriteArrayList<LoggingEvent>();

    public LogInterceptor() {
        try {
            Field field = Log4jLoggerAdapter.class.getDeclaredField("logger");
            field.setAccessible(true);
            Logger logger = (Logger)field.get(LoggerFactory.getLogger((String)"ROOT"));
            logger.addAppender((Appender)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain Log4j logger for log interceptor.");
        }
    }

    protected void append(LoggingEvent loggingEvent) {
        this.events.add(loggingEvent);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public boolean containsMessage(String text) {
        for (LoggingEvent event : this.events) {
            if (!event.getMessage().toString().contains(text)) continue;
            return true;
        }
        return false;
    }

    public boolean containsWarnMessage(String text) {
        return this.containsMessage(Level.WARN, text);
    }

    public boolean containsErrorMessage(String text) {
        return this.containsMessage(Level.ERROR, text);
    }

    public boolean containsStacktraceElement(String text) {
        for (LoggingEvent event : this.events) {
            String[] stackTrace = event.getThrowableStrRep();
            if (stackTrace == null) continue;
            for (String element : stackTrace) {
                if (!element.contains(text)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsMessage(Level level, String text) {
        for (LoggingEvent event : this.events) {
            if (!event.getLevel().equals((Object)level) || !event.getMessage().toString().contains(text)) continue;
            return true;
        }
        return false;
    }
}

