/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigurationDefaults;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotChangeEventSource
implements SnapshotChangeEventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSnapshotChangeEventSource.class);
    private final CommonConnectorConfig connectorConfig;
    protected final OffsetContext previousOffset;
    private final SnapshotProgressListener snapshotProgressListener;

    public AbstractSnapshotChangeEventSource(CommonConnectorConfig connectorConfig, OffsetContext previousOffset, SnapshotProgressListener snapshotProgressListener) {
        this.connectorConfig = connectorConfig;
        this.previousOffset = previousOffset;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    @Override
    public SnapshotResult execute(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        SnapshotContext ctx;
        SnapshottingTask snapshottingTask = this.getSnapshottingTask(this.previousOffset);
        if (snapshottingTask.shouldSkipSnapshot()) {
            LOGGER.debug("Skipping snapshotting");
            return SnapshotResult.skipped(this.previousOffset);
        }
        this.delaySnapshotIfNeeded(context);
        try {
            ctx = this.prepare(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize snapshot context.", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            SnapshotResult e = this.doExecute(context, ctx, snapshottingTask);
            return e;
        }
        catch (InterruptedException e) {
            LOGGER.warn("Snapshot was interrupted before completion");
            this.snapshotProgressListener.snapshotAborted();
            throw e;
        }
        catch (RuntimeException e) {
            this.snapshotProgressListener.snapshotAborted();
            throw e;
        }
        catch (Throwable t) {
            this.snapshotProgressListener.snapshotAborted();
            throw new RuntimeException(t);
        }
        finally {
            LOGGER.info("Snapshot - Final stage");
            this.complete(ctx);
        }
    }

    protected <T extends DataCollectionId> Stream<T> determineDataCollectionsToBeSnapshotted(Collection<T> allDataCollections) {
        Set<String> snapshotAllowedDataCollections = this.connectorConfig.getDataCollectionsToBeSnapshotted();
        if (snapshotAllowedDataCollections.size() == 0) {
            return allDataCollections.stream();
        }
        return allDataCollections.stream().filter(dataCollectionId -> snapshotAllowedDataCollections.stream().anyMatch(s -> dataCollectionId.identifier().matches((String)s)));
    }

    protected void delaySnapshotIfNeeded(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        Duration snapshotDelay = this.connectorConfig.getSnapshotDelay();
        if (snapshotDelay.isZero() || snapshotDelay.isNegative()) {
            return;
        }
        Threads.Timer timer = Threads.timer(Clock.SYSTEM, snapshotDelay);
        Metronome metronome = Metronome.parker(ConfigurationDefaults.RETURN_CONTROL_INTERVAL, Clock.SYSTEM);
        while (!timer.expired()) {
            if (!context.isRunning()) {
                throw new InterruptedException("Interrupted while awaiting initial snapshot delay");
            }
            LOGGER.info("The connector will wait for {}s before proceeding", (Object)timer.remaining().getSeconds());
            metronome.pause();
        }
    }

    protected abstract SnapshotResult doExecute(ChangeEventSource.ChangeEventSourceContext var1, SnapshotContext var2, SnapshottingTask var3) throws Exception;

    protected abstract SnapshottingTask getSnapshottingTask(OffsetContext var1);

    protected abstract SnapshotContext prepare(ChangeEventSource.ChangeEventSourceContext var1) throws Exception;

    protected abstract void complete(SnapshotContext var1);

    public static class SnapshottingTask {
        private final boolean snapshotSchema;
        private final boolean snapshotData;

        public SnapshottingTask(boolean snapshotSchema, boolean snapshotData) {
            this.snapshotSchema = snapshotSchema;
            this.snapshotData = snapshotData;
        }

        public boolean snapshotData() {
            return this.snapshotData;
        }

        public boolean snapshotSchema() {
            return this.snapshotSchema;
        }

        public boolean shouldSkipSnapshot() {
            return !this.snapshotSchema() && !this.snapshotData();
        }

        public String toString() {
            return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
        }
    }

    public static class SnapshotContext
    implements AutoCloseable {
        public OffsetContext offset;

        @Override
        public void close() throws Exception {
        }
    }
}

