/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.kafka;

import io.debezium.annotation.ThreadSafe;
import io.debezium.util.IoUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ZookeeperServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperServer.class);
    public static int DEFAULT_TICK_TIME = 500;
    private volatile int tickTime = DEFAULT_TICK_TIME;
    private volatile int port = -1;
    private volatile ServerCnxnFactory factory;
    private volatile File dataDir;
    private volatile File snapshotDir;
    private volatile File logDir;
    private volatile ZooKeeperServer server;

    public synchronized ZookeeperServer startup() throws IOException {
        if (this.factory != null) {
            throw new IllegalStateException("" + this + " is already running");
        }
        if (this.port == -1) {
            this.port = IoUtil.getAvailablePort();
        }
        this.factory = ServerCnxnFactory.createFactory((InetSocketAddress)new InetSocketAddress("localhost", this.port), (int)1024);
        if (this.dataDir == null) {
            try {
                File temp = File.createTempFile("kafka", "suffix");
                this.dataDir = temp.getParentFile();
                temp.delete();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary directory", e);
            }
        }
        this.snapshotDir = new File(this.dataDir, "snapshot");
        this.logDir = new File(this.dataDir, "log");
        this.snapshotDir.mkdirs();
        this.logDir.mkdirs();
        try {
            this.server = new ZooKeeperServer(this.snapshotDir, this.logDir, this.tickTime);
            this.factory.startup(this.server);
            return this;
        }
        catch (InterruptedException e) {
            this.factory = null;
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void shutdown(boolean deleteData) {
        if (this.factory == null) return;
        try {
            this.factory.shutdown();
            try {
                this.server.getZKDatabase().close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to close zookeeper DB", (Throwable)e);
            }
            this.factory = null;
            if (!deleteData) return;
        }
        catch (Throwable throwable) {
            this.factory = null;
            if (!deleteData) throw throwable;
            try {
                IoUtil.delete((File[])new File[]{this.snapshotDir, this.logDir});
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Unable to delete data upon shutdown", (Throwable)e);
            }
            throw throwable;
        }
        try {
            IoUtil.delete((File[])new File[]{this.snapshotDir, this.logDir});
            return;
        }
        catch (IOException e) {
            LOGGER.error("Unable to delete data upon shutdown", (Throwable)e);
        }
    }

    public String getConnection() {
        return "localhost:" + this.port;
    }

    public ZookeeperServer setPort(int port) {
        this.port = port;
        return this;
    }

    public ZookeeperServer setTickTime(int tickTime) {
        this.tickTime = tickTime > 0 ? tickTime : DEFAULT_TICK_TIME;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    void onEachDirectory(Consumer<File> consumer) {
        consumer.accept(this.getSnapshotDirectory());
        consumer.accept(this.getLogDirectory());
    }

    File getSnapshotDirectory() {
        return this.snapshotDir;
    }

    File getLogDirectory() {
        return this.logDir;
    }

    public File getStateDirectory() {
        return this.logDir;
    }

    public ZookeeperServer setStateDirectory(File dataDir) {
        if (dataDir != null && dataDir.exists() && !dataDir.isDirectory() && !dataDir.canWrite() && !dataDir.canRead()) {
            throw new IllegalArgumentException("The directory must be readable and writable");
        }
        this.dataDir = dataDir;
        return this;
    }

    public String toString() {
        return "ZookeeperServer{" + this.getConnection() + "}";
    }
}

