/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.MaskStrings;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MaskStringsTest {
    private final Column column = Column.editor().name("col").jdbcType(12).create();
    private ValueConverter converter;

    @Test
    public void shouldMaskStringsWithAsterisks() {
        String maskValue = "*****";
        this.converter = new MaskStrings(maskValue).create(this.column);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123456").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12345").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1234").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert(null).toString()).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldTransformSameInputsToSameResultsForCharsetType() {
        this.converter = new MaskStrings("salt".getBytes(), "SHA-256").create(this.column);
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"af5843a0f0e728ab0332c8888b6e1190bfb79e584f0d40538de8f10df6ef29c6");
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"af5843a0f0e728ab0332c8888b6e1190bfb79e584f0d40538de8f10df6ef29c6");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"4588e1f2dcdc7fefc1515d3acd5acb9033478eace68286f383c337b9ff4464a3");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"4588e1f2dcdc7fefc1515d3acd5acb9033478eace68286f383c337b9ff4464a3");
    }
}

