/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.spi;

import io.debezium.DebeziumException;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import java.util.Map;

public final class Offsets<P extends Partition, O extends OffsetContext> {
    private final Map<P, O> offsets;

    public Offsets(Map<P, O> offsets) {
        this.offsets = offsets;
    }

    public void resetOffset(P partition) {
        this.offsets.put(partition, null);
    }

    public P getTheOnlyPartition() {
        if (this.offsets.size() != 1) {
            throw new DebeziumException("The task must be configured to use exactly one partition, " + this.offsets.size() + " found");
        }
        return (P)((Partition)this.offsets.entrySet().iterator().next().getKey());
    }

    public O getTheOnlyOffset() {
        if (this.offsets.size() != 1) {
            throw new DebeziumException("The task must be configured to use exactly one partition, " + this.offsets.size() + " found");
        }
        return (O)((OffsetContext)this.offsets.entrySet().iterator().next().getValue());
    }
}

