/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.function;

import io.debezium.function.Predicates;
import java.util.UUID;
import java.util.function.Predicate;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class PredicatesTest {
    @Test
    public void shouldMatchCommaSeparatedRegexIncludes() {
        Predicate p = Predicates.includes((String)"1.*5,30");
        Assertions.assertThat((boolean)p.test("30")).isTrue();
        Assertions.assertThat((boolean)p.test("1005")).isTrue();
        Assertions.assertThat((boolean)p.test("105")).isTrue();
        Assertions.assertThat((boolean)p.test("15")).isTrue();
        Assertions.assertThat((boolean)p.test("215")).isFalse();
        Assertions.assertThat((boolean)p.test("150")).isFalse();
        Assertions.assertThat((boolean)p.test("015")).isFalse();
        Assertions.assertThat((boolean)p.test("5")).isFalse();
    }

    @Test
    public void shouldMatchCommaSeparatedLiteralIncludes() {
        Predicate p = Predicates.includes((String)"1,2,3,4,5", i -> i.toString());
        Assertions.assertThat((boolean)p.test(1)).isTrue();
        Assertions.assertThat((boolean)p.test(2)).isTrue();
        Assertions.assertThat((boolean)p.test(3)).isTrue();
        Assertions.assertThat((boolean)p.test(4)).isTrue();
        Assertions.assertThat((boolean)p.test(5)).isTrue();
        Assertions.assertThat((boolean)p.test(0)).isFalse();
        Assertions.assertThat((boolean)p.test(6)).isFalse();
        Assertions.assertThat((boolean)p.test(-1)).isFalse();
    }

    @Test
    public void shouldMatchCommaSeparatedLiteralExcludes() {
        Predicate p = Predicates.excludes((String)"1,2,3,4,5", i -> i.toString());
        Assertions.assertThat((boolean)p.test(1)).isFalse();
        Assertions.assertThat((boolean)p.test(2)).isFalse();
        Assertions.assertThat((boolean)p.test(3)).isFalse();
        Assertions.assertThat((boolean)p.test(4)).isFalse();
        Assertions.assertThat((boolean)p.test(5)).isFalse();
        Assertions.assertThat((boolean)p.test(0)).isTrue();
        Assertions.assertThat((boolean)p.test(6)).isTrue();
        Assertions.assertThat((boolean)p.test(-1)).isTrue();
    }

    @Test
    public void shouldMatchCommaSeparatedUuidLiterals() {
        String uuid1 = UUID.randomUUID().toString();
        String uuid2 = UUID.randomUUID().toString();
        String uuid3 = UUID.randomUUID().toString();
        String uuid4 = UUID.randomUUID().toString();
        String uuid4Prefix = uuid4.substring(0, 10) + ".*";
        Predicate p = Predicates.includesUuids((String)(uuid1 + "," + uuid2));
        Assertions.assertThat((boolean)p.test(uuid1)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid2)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid3)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid4)).isFalse();
        p = Predicates.excludesUuids((String)(uuid1 + "," + uuid2));
        Assertions.assertThat((boolean)p.test(uuid1)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid2)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid3)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid4)).isTrue();
        p = Predicates.includesUuids((String)(uuid1 + "," + uuid2 + "," + uuid4Prefix));
        Assertions.assertThat((boolean)p.test(uuid1)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid2)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid3)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid4)).isTrue();
        p = Predicates.excludesUuids((String)(uuid1 + "," + uuid2 + "," + uuid4Prefix));
        Assertions.assertThat((boolean)p.test(uuid1)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid2)).isFalse();
        Assertions.assertThat((boolean)p.test(uuid3)).isTrue();
        Assertions.assertThat((boolean)p.test(uuid4)).isFalse();
    }
}

