/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.LoggerFactory;

public class LogInterceptor
extends AppenderBase<ILoggingEvent> {
    private List<ILoggingEvent> events = new CopyOnWriteArrayList<ILoggingEvent>();

    protected LogInterceptor() {
        try {
            Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
            this.start();
            rootLogger.addAppender((Appender)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain logback logger for log interceptor.", e);
        }
    }

    public LogInterceptor(String loggerName) {
        try {
            Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
            this.start();
            logger.addAppender((Appender)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain logback logger for log interceptor.", e);
        }
    }

    public LogInterceptor(Class<?> clazz) {
        this(clazz.getName());
    }

    protected void append(ILoggingEvent loggingEvent) {
        this.events.add(loggingEvent);
    }

    public void setLoggerLevel(Class<?> loggerClass, String level) {
    }

    public long countOccurrences(String text) {
        return this.events.stream().filter(e -> e.getMessage().toString().contains(text)).count();
    }

    public boolean containsMessage(String text) {
        for (ILoggingEvent event : this.events) {
            if (!event.getFormattedMessage().toString().contains(text)) continue;
            return true;
        }
        return false;
    }

    public boolean containsWarnMessage(String text) {
        return this.containsMessage(Level.WARN, text);
    }

    public boolean containsErrorMessage(String text) {
        return this.containsMessage(Level.ERROR, text);
    }

    public boolean containsStacktraceElement(String text) {
        for (ILoggingEvent event : this.events) {
            for (IThrowableProxy stackTrace = event.getThrowableProxy(); stackTrace != null; stackTrace = stackTrace.getCause()) {
                if (!(stackTrace.getClassName() + ": " + stackTrace.getMessage()).contains(text)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsMessage(Level level, String text) {
        for (ILoggingEvent event : this.events) {
            if (!event.getLevel().equals(level) || !event.getFormattedMessage().toString().contains(text)) continue;
            return true;
        }
        return false;
    }
}

