/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.converters.spi.SerializerType;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.storage.ConverterConfig;

public class CloudEventsConverterConfig
extends ConverterConfig {
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_CONFIG = "serializer.type";
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize CloudEvents values";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG = "data.serializer.type";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize the data field of CloudEvents values";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG = "schema.name.adjustment.mode";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT = "avro";
    private static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC = "Specify how schema names should be adjusted for compatibility with the message converter used by the connector, including:'avro' replaces the characters that cannot be used in the Avro type name with underscore (default)'none' does not apply any adjustment";
    private static final ConfigDef CONFIG = ConverterConfig.newConfigDef();

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public CloudEventsConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public SerializerType cloudeventsSerializerType() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG));
    }

    public SerializerType cloudeventsDataSerializerTypeConfig() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG));
    }

    public CommonConnectorConfig.SchemaNameAdjustmentMode schemaNameAdjustmentMode() {
        return CommonConnectorConfig.SchemaNameAdjustmentMode.parse(this.getString(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG));
    }

    static {
        CONFIG.define(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG, ConfigDef.Type.STRING, (Object)CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC);
    }
}

