/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;

public class SchemaBuilderUtil {
    public static Schema jsonNodeToSchema(JsonNode document) {
        return SchemaBuilderUtil.jsonNodeToSchemaBuilder(document).build();
    }

    private static SchemaBuilder jsonNodeToSchemaBuilder(JsonNode document) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().optional();
        if (document != null) {
            Iterator fieldsEntries = document.fields();
            while (fieldsEntries.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fieldsEntries.next();
                SchemaBuilderUtil.addFieldSchema(fieldEntry, schemaBuilder);
            }
        }
        return schemaBuilder;
    }

    private static void addFieldSchema(Map.Entry<String, JsonNode> fieldEntry, SchemaBuilder builder) {
        String fieldName = fieldEntry.getKey();
        JsonNode fieldValue = fieldEntry.getValue();
        Schema fieldSchema = SchemaBuilderUtil.jsonValueToSchema(fieldValue);
        if (fieldSchema != null && !SchemaBuilderUtil.hasField(builder, fieldName)) {
            builder.field(fieldName, fieldSchema);
        }
    }

    private static Schema jsonValueToSchema(JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case NUMBER: {
                if (node.isInt()) {
                    return Schema.OPTIONAL_INT32_SCHEMA;
                }
                if (node.isLong()) {
                    return Schema.OPTIONAL_INT64_SCHEMA;
                }
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)node;
                return arrayNode.isEmpty() ? null : SchemaBuilder.array((Schema)SchemaBuilderUtil.findArrayMemberSchema(arrayNode)).optional().build();
            }
            case OBJECT: {
                return SchemaBuilderUtil.jsonNodeToSchema(node);
            }
        }
        return null;
    }

    private static JsonNode getFirstArrayElement(ArrayNode array) throws ConnectException {
        NullNode refNode = NullNode.getInstance();
        Schema refSchema = null;
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            Schema elementSchema;
            JsonNode element = (JsonNode)elements.next();
            if (element.isNull()) continue;
            if (refNode.isNull()) {
                refNode = element;
            }
            if (element.getNodeType() != refNode.getNodeType()) {
                throw new ConnectException(String.format("Field is not a homogenous array (%s x %s).", refNode.asText(), element.getNodeType().toString()));
            }
            if (refNode.getNodeType() != JsonNodeType.NUMBER) continue;
            if (refSchema == null) {
                refSchema = SchemaBuilderUtil.jsonValueToSchema((JsonNode)refNode);
            }
            if (refSchema == (elementSchema = SchemaBuilderUtil.jsonValueToSchema(element))) continue;
            throw new ConnectException(String.format("Field is not a homogenous array (%s x %s), different number types (%s x %s)", refNode.asText(), element.asText(), refSchema, elementSchema));
        }
        return refNode;
    }

    private static Schema findArrayMemberSchema(ArrayNode array) throws ConnectException {
        JsonNode sample = SchemaBuilderUtil.getFirstArrayElement(array);
        if (sample.isObject()) {
            return SchemaBuilderUtil.buildDocumentUnionSchema(array);
        }
        Schema schema = SchemaBuilderUtil.jsonValueToSchema(sample);
        if (schema == null) {
            throw new ConnectException(String.format("Array '%s' has unrecognized member schema.", array.asText()));
        }
        return schema;
    }

    private static Schema buildDocumentUnionSchema(ArrayNode array) {
        SchemaBuilder builder = null;
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            if (!element.isObject()) continue;
            if (builder == null) {
                builder = SchemaBuilderUtil.jsonNodeToSchemaBuilder(element);
                continue;
            }
            Iterator fieldsEntries = element.fields();
            while (fieldsEntries.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fieldsEntries.next();
                SchemaBuilderUtil.addFieldSchema(fieldEntry, builder);
            }
        }
        return builder.build();
    }

    private static boolean hasField(SchemaBuilder builder, String fieldName) {
        return builder.field(fieldName) != null;
    }
}

