/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.DatabaseVersionResolver;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class DatabaseVersionResolverTest {
    private DatabaseVersionResolver.DatabaseVersion databaseVersion;

    @Test
    public void testAnnotationLessThanGivenMajorVersion() throws Exception {
        Assertions.assertThat((boolean)this.checkLessThan(11, 14, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkLessThan(11, 0, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkLessThan(12, 0, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkLessThan(10, 0, 0, 11, -1, -1)).isTrue();
    }

    @Test
    public void testAnnotationLessThanOrEqualGivenMajorVersion() throws Exception {
        Assertions.assertThat((boolean)this.checkLessThanEqualTo(11, 14, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkLessThanEqualTo(11, 0, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkLessThanEqualTo(12, 0, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkLessThanEqualTo(10, 0, 0, 11, -1, -1)).isTrue();
    }

    @Test
    public void testAnnotationEqualToGivenMajorVersion() throws Exception {
        Assertions.assertThat((boolean)this.checkEqualTo(11, 14, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkEqualTo(11, 0, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkEqualTo(12, 0, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkEqualTo(10, 0, 0, 11, -1, -1)).isFalse();
    }

    @Test
    public void testAnnotationGreaterThanOrEqualToGivenMajorVersion() throws Exception {
        Assertions.assertThat((boolean)this.checkGreaterThanOrEqualTo(11, 14, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkGreaterThanOrEqualTo(11, 0, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkGreaterThanOrEqualTo(12, 0, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkGreaterThanOrEqualTo(10, 0, 0, 11, -1, -1)).isFalse();
    }

    @Test
    public void testAnnotationGreaterThanGivenMajorVersion() throws Exception {
        Assertions.assertThat((boolean)this.checkGreaterThan(11, 14, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkGreaterThan(11, 0, 0, 11, -1, -1)).isFalse();
        Assertions.assertThat((boolean)this.checkGreaterThan(12, 0, 0, 11, -1, -1)).isTrue();
        Assertions.assertThat((boolean)this.checkGreaterThan(10, 0, 0, 11, -1, -1)).isFalse();
    }

    private boolean checkLessThan(int dbMajor, int dbMinor, int dbPatch, int major, int minor, int patch) {
        DatabaseVersionResolver.DatabaseVersion dbVersion = new DatabaseVersionResolver.DatabaseVersion(dbMajor, dbMinor, dbPatch);
        return dbVersion.isLessThan(major, minor, patch);
    }

    private boolean checkLessThanEqualTo(int dbMajor, int dbMinor, int dbPatch, int major, int minor, int patch) {
        DatabaseVersionResolver.DatabaseVersion dbVersion = new DatabaseVersionResolver.DatabaseVersion(dbMajor, dbMinor, dbPatch);
        return dbVersion.isLessThanEqualTo(major, minor, patch);
    }

    private boolean checkEqualTo(int dbMajor, int dbMinor, int dbPatch, int major, int minor, int patch) {
        DatabaseVersionResolver.DatabaseVersion dbVersion = new DatabaseVersionResolver.DatabaseVersion(dbMajor, dbMinor, dbPatch);
        return dbVersion.isEqualTo(major, minor, patch);
    }

    private boolean checkGreaterThanOrEqualTo(int dbMajor, int dbMinor, int dbPatch, int major, int minor, int patch) {
        DatabaseVersionResolver.DatabaseVersion dbVersion = new DatabaseVersionResolver.DatabaseVersion(dbMajor, dbMinor, dbPatch);
        return dbVersion.isGreaterThanEqualTo(major, minor, patch);
    }

    private boolean checkGreaterThan(int dbMajor, int dbMinor, int dbPatch, int major, int minor, int patch) {
        DatabaseVersionResolver.DatabaseVersion dbVersion = new DatabaseVersionResolver.DatabaseVersion(dbMajor, dbMinor, dbPatch);
        return dbVersion.isGreaterThan(major, minor, patch);
    }
}

