/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import com.fasterxml.jackson.databind.JsonNode;
import io.debezium.converters.BinaryDataConverter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinaryDataConverterTest {
    private static final String TOPIC = "topic";
    private static final byte[] SAMPLE_BYTES = "sample string".getBytes(StandardCharsets.UTF_8);
    private final BinaryDataConverter converter = new BinaryDataConverter();

    @Before
    public void setUp() {
        this.converter.configure(Collections.emptyMap(), false);
    }

    @Test
    public void shouldConvertFromBytesData() {
        Assertions.assertThat((byte[])this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)SAMPLE_BYTES)).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertFromByteBufferData() {
        Assertions.assertThat((byte[])this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap(SAMPLE_BYTES))).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertFromBytesDataWithNullSchema() {
        Assertions.assertThat((byte[])this.converter.fromConnectData(TOPIC, null, (Object)SAMPLE_BYTES)).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertFromByteBufferDataWithNullSchema() {
        Assertions.assertThat((byte[])this.converter.fromConnectData(TOPIC, null, (Object)ByteBuffer.wrap(SAMPLE_BYTES))).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldThrowExceptionWhenInvalidSchema() {
        Assert.assertThrows(DataException.class, () -> this.converter.fromConnectData(TOPIC, Schema.INT32_SCHEMA, (Object)SAMPLE_BYTES));
    }

    @Test
    public void shouldThrowExceptionWhenInvalidValue() {
        Assert.assertThrows(DataException.class, () -> this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, (Object)12));
    }

    @Test
    public void shouldReturnNullWhenConvertingNullValue() {
        Assertions.assertThat((byte[])this.converter.fromConnectData(TOPIC, Schema.BYTES_SCHEMA, null)).isNull();
    }

    @Test
    public void shouldConvertBytesFromDataIgnoringHeader() {
        Assertions.assertThat((byte[])this.converter.fromConnectHeader(TOPIC, "ignored", Schema.BYTES_SCHEMA, (Object)SAMPLE_BYTES)).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertByteBufferFromDataIgnoringHeader() {
        Assertions.assertThat((byte[])this.converter.fromConnectHeader(TOPIC, "ignored", Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap(SAMPLE_BYTES))).isEqualTo(SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertBytesToConnectData() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, SAMPLE_BYTES);
        Assertions.assertThat((Object)data.schema()).isEqualTo((Object)Schema.OPTIONAL_BYTES_SCHEMA);
        Assertions.assertThat((Object)data.value()).isEqualTo((Object)SAMPLE_BYTES);
    }

    @Test
    public void shouldConvertToConnectDataForNullValue() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, null);
        Assertions.assertThat((Object)data.schema()).isEqualTo((Object)Schema.OPTIONAL_BYTES_SCHEMA);
        Assertions.assertThat((Object)data.value()).isNull();
    }

    @Test
    public void shouldThrowWhenNoDelegateConverterConfigured() {
        try {
            this.converter.fromConnectData(TOPIC, Schema.OPTIONAL_STRING_SCHEMA, (Object)"Hello World");
            TestCase.fail((String)"now expected exception thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(DataException.class);
        }
    }

    @Test
    public void shouldThrowWhenNoSchemaOrDelegateConverterConfigured() {
        try {
            this.converter.fromConnectData(TOPIC, null, (Object)"Hello World");
            TestCase.fail((String)"now expected exception thrown");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(DataException.class);
        }
    }

    @Test
    public void shouldConvertUsingDelegateConverter() {
        this.converter.configure(Collections.singletonMap("delegate.converter.type", JsonConverter.class.getName()), false);
        byte[] data = this.converter.fromConnectData(TOPIC, Schema.OPTIONAL_STRING_SCHEMA, (Object)"{\"message\": \"Hello World\"}");
        JsonNode value = null;
        try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
            value = jsonDeserializer.deserialize(TOPIC, data);
        }
        Assertions.assertThat((Iterable)value).isNotNull();
        Assertions.assertThat((Iterable)value.get("schema")).isNotNull();
        Assertions.assertThat((String)value.get("schema").get("type").asText()).isEqualTo((Object)"string");
        Assertions.assertThat((boolean)value.get("schema").get("optional").asBoolean()).isTrue();
        Assertions.assertThat((Iterable)value.get("payload")).isNotNull();
        Assertions.assertThat((String)value.get("payload").asText()).isEqualTo((Object)"{\"message\": \"Hello World\"}");
    }

    @Test
    public void shouldConvertUsingDelegateConverterWithNoSchema() {
        this.converter.configure(Collections.singletonMap("delegate.converter.type", JsonConverter.class.getName()), false);
        byte[] data = this.converter.fromConnectData(TOPIC, null, (Object)"{\"message\": \"Hello World\"}");
        JsonNode value = null;
        try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
            value = jsonDeserializer.deserialize(TOPIC, data);
        }
        Assertions.assertThat((Iterable)value).isNotNull();
        Assertions.assertThat((Iterable)value.get("schema")).isNotNull();
        Assertions.assertThat((String)value.get("schema").asText()).isEqualTo((Object)"null");
        Assertions.assertThat((Iterable)value.get("payload")).isNotNull();
        Assertions.assertThat((String)value.get("payload").asText()).isEqualTo((Object)"{\"message\": \"Hello World\"}");
    }

    @Test
    public void shouldConvertUsingDelegateConverterWithOptionsAndNoSchema() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("delegate.converter.type", JsonConverter.class.getName());
        config.put("delegate.converter.type.schemas.enable", Boolean.FALSE.toString());
        this.converter.configure(config, false);
        byte[] data = this.converter.fromConnectData(TOPIC, null, (Object)"{\"message\": \"Hello World\"}");
        JsonNode value = null;
        try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
            value = jsonDeserializer.deserialize(TOPIC, data);
        }
        Assertions.assertThat((boolean)value.has("schema")).isFalse();
        Assertions.assertThat((boolean)value.has("payload")).isFalse();
        Assertions.assertThat((String)value.asText()).isEqualTo((Object)"{\"message\": \"Hello World\"}");
    }
}

