/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.VerifyRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;

public class SourceRecordAssert {
    private final SourceRecord record;

    public static SourceRecordAssert assertThat(SourceRecord sourceRecord) {
        return new SourceRecordAssert(sourceRecord);
    }

    private SourceRecordAssert(SourceRecord record) {
        this.record = record;
    }

    public SourceRecordAssert valueAfterFieldIsEqualTo(Struct expectedValue) {
        Struct value = (Struct)this.record.value();
        Struct afterValue = (Struct)value.get("after");
        Assertions.assertThat((Object)afterValue).isEqualTo((Object)expectedValue);
        return this;
    }

    public SourceRecordAssert valueAfterFieldSchemaIsEqualTo(Schema expectedSchema) {
        Schema valueSchema = this.record.valueSchema();
        Schema afterFieldSchema = valueSchema.field("after").schema();
        VerifyRecord.assertConnectSchemasAreEqual(null, afterFieldSchema, expectedSchema);
        return this;
    }

    public SourceRecordAssert keySchemaIsEqualTo(Schema expectedSchema) {
        VerifyRecord.assertConnectSchemasAreEqual(null, this.record.keySchema(), expectedSchema);
        return this;
    }
}

