/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.EqualityCheck;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface SkipWhenKafkaVersion {
    public KafkaVersion value();

    public EqualityCheck check();

    public String description() default "";

    public static enum KafkaVersion {
        KAFKA_1XX{

            @Override
            boolean isLessThan(int major, int minor, int patch) {
                return major < 1;
            }

            @Override
            boolean isLessThanOrEqualTo(int major, int minor, int patch) {
                return this.isLessThan(major, minor, patch) || this.isEqualTo(major, minor, patch);
            }

            @Override
            boolean isEqualTo(int major, int minor, int patch) {
                return major == 1;
            }

            @Override
            boolean isGreaterThanOrEqualTo(int major, int minor, int patch) {
                return major > 1 || this.isEqualTo(major, minor, patch);
            }

            @Override
            boolean isGreaterThan(int major, int minor, int patch) {
                return major > 1;
            }
        }
        ,
        KAFKA_241{

            @Override
            boolean isLessThan(int major, int minor, int patch) {
                return major < 2 || major == 2 && minor < 4 || major == 2 && minor == 4 && patch < 1;
            }

            @Override
            boolean isLessThanOrEqualTo(int major, int minor, int patch) {
                return this.isLessThan(major, minor, patch) || this.isEqualTo(major, minor, patch);
            }

            @Override
            boolean isEqualTo(int major, int minor, int patch) {
                return major == 2 && minor == 4 && patch == 1;
            }

            @Override
            boolean isGreaterThanOrEqualTo(int major, int minor, int patch) {
                return !this.isLessThan(major, minor, patch) || this.isEqualTo(major, minor, patch);
            }

            @Override
            boolean isGreaterThan(int major, int minor, int patch) {
                return !this.isLessThan(major, minor, patch) && !this.isEqualTo(major, minor, patch);
            }
        };


        abstract boolean isLessThan(int var1, int var2, int var3);

        abstract boolean isLessThanOrEqualTo(int var1, int var2, int var3);

        abstract boolean isEqualTo(int var1, int var2, int var3);

        abstract boolean isGreaterThanOrEqualTo(int var1, int var2, int var3);

        abstract boolean isGreaterThan(int var1, int var2, int var3);
    }
}

