/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.relational.Attribute;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.ConnectTableChangeSerializer;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.Clock;
import io.debezium.util.Collect;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class HistoryRecordTest {
    @Test
    public void canSerializeAndDeserializeHistoryRecord() throws Exception {
        Map source = Collect.linkMapOf((Object)"server", (Object)"abc");
        Map position = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"positionInt", (Object)100, (Object)"positionLong", (Object)Long.MAX_VALUE, (Object)"entry", (Object)1);
        String databaseName = "db";
        String schemaName = "myschema";
        String ddl = "CREATE TABLE foo (  first VARCHAR(22) NOT NULL COMMENT 'first comment',  second ENUM('1','2') NOT NULL DEFAULT '1'  third VARCHAR(22) NULL DEFAULT '1' COMMENT 'third comment') COMMENT='table comment';";
        Table table = Table.editor().tableId(new TableId(databaseName, schemaName, "foo")).addColumn(Column.editor().name("first").jdbcType(12).type("VARCHAR").length(22).optional(false).comment("first comment").create()).addColumn(Column.editor().name("second").jdbcType(4).type("ENUM", "ENUM").optional(false).defaultValueExpression("1").enumValues(Collect.arrayListOf((Object)"1", (Object[])new String[]{"2"})).create()).addColumn(Column.editor().name("third").jdbcType(12).type("VARCHAR").length(22).optional(true).defaultValueExpression("1").comment("third comment").create()).setPrimaryKeyNames(new String[]{"first"}).setComment("table comment").addAttribute(Attribute.editor().name("object_id").value((Object)"12345").create()).addAttribute(Attribute.editor().name("other").value((Object)"test").create()).create();
        TableChanges tableChanges = new TableChanges().create(table);
        Instant timestamp = Clock.SYSTEM.currentTimeAsInstant();
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, tableChanges, timestamp);
        String serialized = record.toString();
        DocumentReader reader = DocumentReader.defaultReader();
        HistoryRecord deserialized = new HistoryRecord(reader.read(serialized));
        Assertions.assertThat((Iterable)deserialized.source()).isNotNull();
        Assertions.assertThat((Object)deserialized.source().get((CharSequence)"server")).isEqualTo((Object)"abc");
        Assertions.assertThat((Iterable)deserialized.position()).isNotNull();
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"file")).isEqualTo((Object)"x.log");
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"positionInt")).isEqualTo((Object)100);
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"positionLong")).isEqualTo((Object)Long.MAX_VALUE);
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"entry")).isEqualTo((Object)1);
        Assertions.assertThat((long)deserialized.timestamp()).isEqualTo(timestamp.toEpochMilli());
        Assertions.assertThat((String)deserialized.databaseName()).isEqualTo((Object)databaseName);
        Assertions.assertThat((String)deserialized.schemaName()).isEqualTo((Object)schemaName);
        Assertions.assertThat((String)deserialized.ddl()).isEqualTo((Object)ddl);
        Document secondColumn = deserialized.tableChanges().get(0).asDocument().getDocument((CharSequence)"table").getArray((CharSequence)"columns").get(1).asDocument();
        Assertions.assertThat((Object)secondColumn.get((CharSequence)"defaultValueExpression")).isEqualTo((Object)"1");
        Document firstAttribute = deserialized.tableChanges().get(0).asDocument().getDocument((CharSequence)"table").getArray((CharSequence)"attributes").get(0).asDocument();
        Assertions.assertThat((Object)firstAttribute.get((CharSequence)"name")).isEqualTo((Object)"object_id");
        Assertions.assertThat((Object)firstAttribute.get((CharSequence)"value")).isEqualTo((Object)"12345");
        JsonTableChangeSerializer tableChangesSerializer = new JsonTableChangeSerializer();
        Assertions.assertThat((Object)tableChangesSerializer.deserialize((Object)deserialized.tableChanges(), true)).isEqualTo((Object)tableChanges);
        ConnectTableChangeSerializer connectTableChangeSerializer = new ConnectTableChangeSerializer(SchemaNameAdjuster.NO_OP);
        Struct struct = (Struct)((List)connectTableChangeSerializer.serialize(tableChanges)).get(0);
        Struct tableStruct = (Struct)struct.get("table");
        Assertions.assertThat((Object)tableStruct.get("comment")).isEqualTo((Object)"table comment");
        List columnStructs = (List)tableStruct.get("columns");
        Assertions.assertThat((Object)((Struct)columnStructs.get(0)).get("comment")).isEqualTo((Object)"first comment");
        Assertions.assertThat((Object)((Struct)columnStructs.get(0)).get("enumValues")).isNull();
        Assertions.assertThat((Object)((Struct)columnStructs.get(1)).get("defaultValueExpression")).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((Struct)columnStructs.get(1)).get("enumValues")).isEqualTo((Object)Collect.arrayListOf((Object)"1", (Object[])new String[]{"2"}));
    }
}

