/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.function.Predicates;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;

public abstract class HistorizedRelationalDatabaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 2000;
    private static final String DEFAULT_SCHEMA_HISTORY = "io.debezium.storage.kafka.history.KafkaSchemaHistory";
    private boolean useCatalogBeforeSchema;
    private final Class<? extends SourceConnector> connectorClass;
    private final boolean multiPartitionMode;
    private final Predicate<String> ddlFilter;
    public static final Field SCHEMA_HISTORY = Field.create("schema.history.internal").withDisplayName("Database schema history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the SchemaHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'schema.history.internal.' string.").withDefault("io.debezium.storage.kafka.history.KafkaSchemaHistory");
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().history(SCHEMA_HISTORY, SchemaHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL).create();

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, Tables.TableFilter systemTablesFilter, boolean useCatalogBeforeSchema, int defaultSnapshotFetchSize, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, systemTablesFilter, TableId::toString, defaultSnapshotFetchSize, columnFilterMode, useCatalogBeforeSchema);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
        this.ddlFilter = this.createDdlFilter(config);
    }

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, boolean useCatalogBeforeSchema, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, systemTablesFilter, tableIdMapper, 2000, columnFilterMode, useCatalogBeforeSchema);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
        this.ddlFilter = this.createDdlFilter(config);
    }

    public SchemaHistory getSchemaHistory() {
        Configuration config = this.getConfig();
        SchemaHistory schemaHistory = config.getInstance(SCHEMA_HISTORY, SchemaHistory.class);
        if (schemaHistory == null) {
            throw new ConnectException("Unable to instantiate the database schema history class " + config.getString(SCHEMA_HISTORY));
        }
        Configuration schemaHistoryConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)config.subset("schema.history.internal.", false).edit().withDefault(SchemaHistory.NAME, this.getLogicalName() + "-schemahistory")).withDefault(AbstractSchemaHistory.INTERNAL_CONNECTOR_CLASS, this.connectorClass.getName())).withDefault(AbstractSchemaHistory.INTERNAL_CONNECTOR_ID, this.logicalName)).build();
        HistoryRecordComparator historyComparator = this.getHistoryRecordComparator();
        schemaHistory.configure(schemaHistoryConfig, historyComparator, new SchemaHistoryMetrics(this, this.multiPartitionMode()), this.useCatalogBeforeSchema());
        return schemaHistory;
    }

    public boolean useCatalogBeforeSchema() {
        return this.useCatalogBeforeSchema;
    }

    public boolean multiPartitionMode() {
        return this.multiPartitionMode;
    }

    public Predicate<String> getDdlFilter() {
        return this.ddlFilter;
    }

    private Predicate<String> createDdlFilter(Configuration config) {
        String ddlFilter = config.getString(SchemaHistory.DDL_FILTER);
        return ddlFilter != null ? Predicates.includes(ddlFilter, 34) : x -> false;
    }

    protected abstract HistoryRecordComparator getHistoryRecordComparator();
}

