/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.doc.FixFor;
import io.debezium.relational.Column;
import io.debezium.relational.mapping.PropagateSourceTypeToSchemaParameter;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PropagateSourceTypeToSchemaParameterTest {
    @Test
    @FixFor(value={"DBZ-644"})
    public void shouldAddTypeInformation() {
        int length = 255;
        Column column = Column.editor().name("col").type("VARCHAR").jdbcType(12).length(length).create();
        SchemaBuilder schemaBuilder = SchemaBuilder.string();
        new PropagateSourceTypeToSchemaParameter().alterFieldSchema(column, schemaBuilder);
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"VARCHAR");
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.length"))).isEqualTo((Object)String.valueOf(length));
    }

    @Test
    @FixFor(value={"DBZ-1073", "DBZ-4000"})
    public void shouldAddColumnScale() {
        int length = 5;
        int scale = 2;
        String comment = "numeric column";
        Column column = Column.editor().name("col").type("NUMERIC").jdbcType(2).length(length).scale(Integer.valueOf(scale)).comment(comment).create();
        SchemaBuilder schemaBuilder = SchemaBuilder.string();
        new PropagateSourceTypeToSchemaParameter().alterFieldSchema(column, schemaBuilder);
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"NUMERIC");
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.length"))).isEqualTo((Object)String.valueOf(length));
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.scale"))).isEqualTo((Object)String.valueOf(scale));
        Assertions.assertThat((String)((String)schemaBuilder.parameters().get("__debezium.source.column.comment"))).isEqualTo((Object)comment);
    }
}

