/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.transforms.AbstractExtractStateTest;
import io.debezium.transforms.ExtractNewRecordState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExtractNewRecordStateTest
extends AbstractExtractStateTest {
    private static final String DROP_TOMBSTONES = "drop.tombstones";
    private static final String HANDLE_DELETES = "delete.handling.mode";
    private static final String ROUTE_BY_FIELD = "route.by.field";
    private static final String ADD_FIELDS = "add.fields";
    private static final String ADD_HEADERS = "add.headers";
    private static final String ADD_FIELDS_PREFIX = "add.fields.prefix";
    private static final String ADD_HEADERS_PREFIX = "add.headers.prefix";
    private static final String DROP_FIELDS_HEADER_NAME = "drop.fields.header.name";
    private static final String DROP_FIELDS_FROM_KEY = "drop.fields.from.key";
    private static final String DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE = "drop.fields.keep.schema.compatible";

    @Test
    public void testTombstoneDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)tombstone))).isNull();
        }
    }

    @Test
    public void testTombstoneDroppedConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "true");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)tombstone))).isNull();
        }
    }

    @Test
    public void testTombstoneForwardConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)tombstone))).isEqualTo((Object)tombstone);
        }
    }

    @Test
    public void testTruncateDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord truncate = this.createTruncateRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)truncate))).isNull();
        }
    }

    private String getSourceRecordHeaderByKey(SourceRecord record, String headerKey) {
        Iterator operationHeader = record.headers().allWithName(headerKey);
        if (!operationHeader.hasNext()) {
            return null;
        }
        Object value = ((Header)operationHeader.next()).value();
        return value != null ? value.toString() : null;
    }

    @Test
    public void testDeleteDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)deleteRecord))).isNull();
        }
    }

    @Test
    public void testHandleDeleteDrop() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "drop");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)deleteRecord))).isNull();
        }
    }

    @Test
    public void testHandleDeleteNone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    public void testHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
        }
    }

    @Test
    public void testHandleCreateRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"false");
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    public void testUnwrapCreateRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("name")).isEqualTo((Object)"myRecord");
        }
    }

    @Test
    @FixFor(value={"DBZ-5166"})
    public void testUnwrapCreateRecordWithOptionalDefaultValue() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecordWithOptionalNull();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("name")).isEqualTo(null);
        }
    }

    @Test
    public void testIgnoreUnknownRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)unknownRecord))).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)unnamedSchemaRecord))).isEqualTo((Object)unnamedSchemaRecord);
        }
    }

    @Test
    @FixFor(value={"DBZ-971"})
    public void testUnwrapPropagatesRecordHeaders() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            createRecord.headers().addString("application/debezium-test-header", "shouldPropagatePreviousRecordHeaders");
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            Iterator headers = unwrapped.headers().allWithName("application/debezium-test-header");
            Assertions.assertThat((boolean)headers.hasNext()).isTrue();
            Assertions.assertThat((String)((Header)headers.next()).value().toString()).isEqualTo((Object)"shouldPropagatePreviousRecordHeaders");
        }
    }

    @Test
    @FixFor(value={"DBZ-1452", "DBZ-6901"})
    public void testAddField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
            SourceRecord createRecordAddingColumn = this.createCreateRecordAddingColumn("started_at", 1694587158123L);
            SourceRecord unwrappedAddingColumn = (SourceRecord)transform.apply((ConnectRecord)createRecordAddingColumn);
            Assertions.assertThat((Object)((Struct)unwrappedAddingColumn.value()).get("started_at")).isEqualTo((Object)1694587158123L);
            createRecordAddingColumn = this.createCreateRecordAddingColumn("started_at", 1694587158789L);
            unwrappedAddingColumn = (SourceRecord)transform.apply((ConnectRecord)createRecordAddingColumn);
            Assertions.assertThat((Object)((Struct)unwrappedAddingColumn.value()).get("started_at")).isEqualTo((Object)1694587158789L);
        }
    }

    @Test
    @FixFor(value={"DBZ-2984"})
    public void testAddTimestamp() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props1 = new HashMap<String, String>();
            props1.put(ADD_FIELDS, "ts_ms");
            transform.configure(props1);
            SourceRecord createRecord1 = this.createCreateRecord();
            SourceRecord unwrapped1 = (SourceRecord)transform.apply((ConnectRecord)createRecord1);
            Assertions.assertThat((Object)((Struct)unwrapped1.value()).get("__ts_ms")).isNotNull();
            HashMap<String, String> props2 = new HashMap<String, String>();
            props2.put(ADD_FIELDS, "source.ts_ms");
            transform.configure(props2);
            SourceRecord createRecord2 = this.createCreateRecord();
            SourceRecord unwrapped2 = (SourceRecord)transform.apply((ConnectRecord)createRecord2);
            Assertions.assertThat((Object)((Struct)unwrapped2.value()).get("__source_ts_ms")).isNotNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452", "DBZ-2504"})
    public void testAddFields() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op , lsn,id");
            props.put(ADD_FIELDS_PREFIX, "prefix.");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.id")).isEqualTo((Object)"571");
        }
    }

    @Test
    @FixFor(value={"DBZ-2606"})
    public void testNewFieldAndHeaderMapping() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            String fieldPrefix = "";
            String headerPrefix = "prefix.";
            props.put(ADD_FIELDS, "op:OP, lsn:LSN, id:ID, source.lsn:source_lsn, transaction.total_order:TOTAL_ORDER");
            props.put(ADD_FIELDS_PREFIX, fieldPrefix);
            props.put(ADD_HEADERS, "op, source.lsn:source_lsn, transaction.id:TXN_ID, transaction.total_order:TOTAL_ORDER");
            props.put(ADD_HEADERS_PREFIX, headerPrefix);
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "OP")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "LSN")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "ID")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "TOTAL_ORDER")).isEqualTo((Object)42L);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(4);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "TXN_ID");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "TOTAL_ORDER");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(42L));
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsForMissingOptionalField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op,lsn,id");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__id")).isEqualTo(null);
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsSpecifyStruct() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op,source.lsn,transaction.id,transaction.total_order");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__transaction_id")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__transaction_total_order")).isEqualTo((Object)42L);
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeader() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeaders() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op , lsn,id");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(3);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__id");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeadersForMissingOptionalField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op,lsn,id");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(3);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__id");
            Assertions.assertThat((String)headerValue).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452", "DBZ-2504"})
    public void testAddHeadersSpecifyStruct() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op,source.lsn,transaction.id,transaction.total_order");
            props.put(ADD_HEADERS_PREFIX, "prefix.");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(4);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.transaction_id");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.transaction_total_order");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(42L));
        }
    }

    @Test
    public void testAddTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrappedCreate = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)unwrappedCreate.topic()).isEqualTo((Object)"myRecord");
        }
    }

    @Test
    public void testUpdateTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((String)unwrapped.topic()).isEqualTo((Object)"updatedRecord");
        }
    }

    @Test
    public void testDeleteTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)deleteRecord)).topic()).isEqualTo((Object)"myRecord");
        }
    }

    @Test
    @FixFor(value={"DBZ-1876"})
    public void testAddHeadersHandleDeleteRewriteAndTombstone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_HEADERS, "op,source.lsn");
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.DELETE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)this.createTombstoneRecord());
            Assertions.assertThat((String)this.getSourceRecordHeaderByKey(tombstone, "__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,lsn");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    @FixFor(value={"DBZ-1876"})
    public void testAddFieldsHandleDeleteRewriteAndTombstone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,lsn");
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)this.createTombstoneRecord());
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsSpecifyStructHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,source.lsn");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__source_lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    @FixFor(value={"DBZ-1517"})
    public void testSchemaChangeEventWithOperationHeader() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)unknownRecord))).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)((SourceRecord)transform.apply((ConnectRecord)unnamedSchemaRecord))).isEqualTo((Object)unnamedSchemaRecord);
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void dropFieldsFromValueWithSchemaCompatibility() {
        List<String> dropFields = List.of("id", "name");
        String dropHeaderName = "drop-fields";
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name("drop-fields").build();
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_FIELDS_HEADER_NAME, "drop-fields");
            transform.configure(props);
            SourceRecord before = this.addDropFieldsHeader(this.createCreateRecordWithOptionalNull(), "drop-fields", dropFields);
            SourceRecord after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createCreateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createUpdateRecordWithOptionalNull(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createUpdateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createDeleteRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
            before = this.addDropFieldsHeader(this.createTombstoneRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void dropFieldsFromValueWithoutSchemaCompatibility() {
        List<String> dropFields = List.of("id", "name");
        String dropHeaderName = "drop-fields";
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name("drop-fields").build();
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_FIELDS_HEADER_NAME, "drop-fields");
            props.put(DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE, "false");
            transform.configure(props);
            SourceRecord before = this.addDropFieldsHeader(this.createCreateRecordWithOptionalNull(), "drop-fields", dropFields);
            SourceRecord after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createCreateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createUpdateRecordWithOptionalNull(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createUpdateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createDeleteRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
            before = this.addDropFieldsHeader(this.createTombstoneRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void dropFieldsFromValueAndKeyWithSchemaCompatibility() {
        List<String> dropFields = List.of("id", "name");
        String dropHeaderName = "drop-fields";
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name("drop-fields").build();
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_FIELDS_HEADER_NAME, "drop-fields");
            props.put(DROP_FIELDS_FROM_KEY, "true");
            transform.configure(props);
            SourceRecord before = this.addDropFieldsHeader(this.createCreateRecordWithOptionalNull(), "drop-fields", dropFields);
            SourceRecord after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createCreateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createUpdateRecordWithOptionalNull(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createUpdateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.key()).get("id")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value()).get("id")).isEqualTo((Object)1);
            before = this.addDropFieldsHeader(this.createDeleteRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
            before = this.addDropFieldsHeader(this.createTombstoneRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void dropFieldsFromValueAndKeyWithoutSchemaCompatibility() {
        List<String> dropFields = List.of("id", "name");
        String dropHeaderName = "drop-fields";
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name("drop-fields").build();
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_FIELDS_HEADER_NAME, "drop-fields");
            props.put(DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE, "false");
            props.put(DROP_FIELDS_FROM_KEY, "true");
            transform.configure(props);
            SourceRecord before = this.addDropFieldsHeader(this.createCreateRecordWithOptionalNull(), "drop-fields", dropFields);
            SourceRecord after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createCreateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNull();
            Assertions.assertThat((Object)after.key()).isEqualTo((Object)new Struct(after.keySchema()));
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createUpdateRecordWithOptionalNull(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.key()).isNull();
            Assertions.assertThat((Object)after.keySchema()).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createUpdateRecordWithKey(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after.keySchema().field("id")).isNull();
            Assertions.assertThat((Object)after.key()).isEqualTo((Object)new Struct(after.keySchema()));
            Assertions.assertThat((Object)after.valueSchema().field("name")).isNull();
            Assertions.assertThat((Object)after.valueSchema().field("id")).isNull();
            Assertions.assertThat((Object)after.value()).isNotNull();
            Assertions.assertThat((Object)((Struct)after.value())).isEqualTo((Object)new Struct(after.valueSchema()));
            before = this.addDropFieldsHeader(this.createDeleteRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
            before = this.addDropFieldsHeader(this.createTombstoneRecord(), "drop-fields", dropFields);
            after = (SourceRecord)transform.apply((ConnectRecord)before);
            Assertions.assertThat((Object)after).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-6486"})
    public void testNewNotDefaultField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            String fieldPrefix = "";
            props.put(ADD_FIELDS, "notExisting,op:OP, lsn:LSN, id:ID, source.lsn:source_lsn, transaction.total_order:TOTAL_ORDER, changes:META_SRC_CHANGED");
            props.put(ADD_FIELDS_PREFIX, fieldPrefix);
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecordWithChangedFields();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "OP")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "LSN")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "ID")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "TOTAL_ORDER")).isEqualTo((Object)42L);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "META_SRC_CHANGED")).isEqualTo(List.of("name"));
            Assertions.assertThat((Object)unwrapped.valueSchema().field("notExisting")).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-6486"})
    public void testFieldNotExists() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            String fieldPrefix = "";
            props.put(ADD_FIELDS, "op:OP, lsn:LSN, id:ID, source.lsn:source_lsn, transaction.total_order:TOTAL_ORDER, notExist:META_SRC_CHANGED");
            props.put(ADD_FIELDS_PREFIX, fieldPrefix);
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecordWithChangedFields();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "OP")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "LSN")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "ID")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "TOTAL_ORDER")).isEqualTo((Object)42L);
        }
    }

    private SourceRecord createUpdateRecordWithChangedFields() {
        Envelope changesEnvelope = Envelope.defineSchema().withName("changedFields.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).withSchema((Schema)SchemaBuilder.array((Schema)Schema.STRING_SCHEMA), new String[]{"changes"}).build();
        Struct before = new Struct(this.recordSchema);
        Struct after = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        ArrayList<String> changes = new ArrayList<String>();
        changes.add("name");
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct struct = new Struct(changesEnvelope.schema());
        struct.put("op", (Object)Envelope.Operation.UPDATE.code());
        if (before != null) {
            struct.put("before", (Object)before);
        }
        struct.put("after", (Object)after);
        if (source != null) {
            struct.put("source", (Object)source);
        }
        if (Instant.now() != null) {
            struct.put("ts_ms", (Object)Instant.now().toEpochMilli());
        }
        struct.put("changes", changes);
        struct.put("transaction", (Object)transaction);
        SourceRecord updateRecord = new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)struct);
        return updateRecord;
    }

    protected SourceRecord addDropFieldsHeader(SourceRecord record, String name, List<String> values) {
        Schema dropFieldsSchema = SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA).optional().name(name).build();
        record.headers().add(name, values, dropFieldsSchema);
        return record;
    }
}

