/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.doc.FixFor;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import io.debezium.transforms.outbox.JsonSchemaData;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class JsonSchemaDataTest {
    private JsonSchemaData jsonSchemaData;
    private ObjectMapper mapper;
    private String record;

    @Before
    public void setup() throws Exception {
        this.jsonSchemaData = new JsonSchemaData();
        this.mapper = new ObjectMapper();
        this.record = this.getFile("json/restaurants5.json");
    }

    @Test
    @FixFor(value={"DBZ-6910"})
    public void shouldCreateCorrectSchemaFromArrayJson() throws Exception {
        String key = "test_arr";
        JsonNode testNode = this.mapper.readTree("[{\"code\":\"100\",\"description\":\"some description\"},{\"code\":\"200\",\"description\":\"another description\"},{\"code\":\"300\"}]");
        Schema arraySchema = this.jsonSchemaData.toConnectSchema(key, testNode);
        Assertions.assertThat((Object)arraySchema.valueSchema().field("code")).isNotNull();
        Assertions.assertThat((Comparable)arraySchema.valueSchema().field("description").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        testNode = this.mapper.readTree("[{\"code\":\"100\",\"description\": null},{\"code\":\"200\",\"description\":\"another description\"},{\"code\":\"300\"}]");
        arraySchema = this.jsonSchemaData.toConnectSchema(key, testNode);
        Assertions.assertThat((Object)arraySchema.valueSchema().field("code")).isNotNull();
        Assertions.assertThat((Comparable)arraySchema.valueSchema().field("description").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        this.jsonSchemaData = new JsonSchemaData(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.OPTIONAL_BYTES);
        testNode = this.mapper.readTree("[{\"code\":\"100\",\"description\": null},{\"code\":\"200\",\"description\": null},{\"code\":\"300\"}]");
        arraySchema = this.jsonSchemaData.toConnectSchema(key, testNode);
        Assertions.assertThat((Object)arraySchema.valueSchema().field("code")).isNotNull();
        Assertions.assertThat((Comparable)arraySchema.valueSchema().field("description").schema().type()).isEqualTo((Object)Schema.Type.BYTES);
        testNode = this.mapper.readTree("[{\"code\":\"100\",\"description\": null},{\"code\":\"200\",\"description\": \"another description\"},{\"code\":\"300\"}]");
        arraySchema = this.jsonSchemaData.toConnectSchema(key, testNode);
        Assertions.assertThat((Object)arraySchema.valueSchema().field("code")).isNotNull();
        Assertions.assertThat((Comparable)arraySchema.valueSchema().field("description").schema().type()).isEqualTo((Object)Schema.Type.STRING);
    }

    @Test
    @FixFor(value={"DBZ-5475"})
    public void failSchemaCheckForArrayWithDifferentNumberTypes() throws Exception {
        JsonNode testNode = this.mapper.readTree("{\"test\": [1, 2.0, 3.0]}");
        ConnectException expectedException = null;
        try {
            this.jsonSchemaData.toConnectSchema(null, testNode);
        }
        catch (ConnectException e) {
            expectedException = e;
        }
        Assertions.assertThat((Throwable)expectedException).isNotNull();
        Assertions.assertThat((Throwable)expectedException).isInstanceOf(ConnectException.class);
        Assertions.assertThat((Throwable)expectedException).hasMessage("Field is not a homogenous array (1 x 2.0), different number types (Schema{INT32} x Schema{FLOAT64})");
    }

    @Test
    @FixFor(value={"DBZ-5654"})
    public void shouldCreateCorrectSchemaFromInsertJson() throws Exception {
        JsonNode recordNode = this.mapper.readTree(this.record);
        Schema schema = this.jsonSchemaData.toConnectSchema("pub", recordNode);
        Assertions.assertThat((Object)schema).isEqualTo((Object)SchemaBuilder.struct().name("pub").optional().field("address", SchemaBuilder.struct().name("pub.address").optional().field("building", Schema.OPTIONAL_STRING_SCHEMA).field("floor", SchemaBuilder.struct().name("pub.address.floor").optional().field("level", Schema.OPTIONAL_INT32_SCHEMA).field("description", Schema.OPTIONAL_STRING_SCHEMA).build()).field("coord", SchemaBuilder.array((Schema)Schema.OPTIONAL_FLOAT64_SCHEMA).optional().build()).field("street", Schema.OPTIONAL_STRING_SCHEMA).field("zipcode", Schema.OPTIONAL_STRING_SCHEMA).build()).field("borough", Schema.OPTIONAL_STRING_SCHEMA).field("cuisine", Schema.OPTIONAL_STRING_SCHEMA).field("grades", SchemaBuilder.array((Schema)SchemaBuilder.struct().name("pub.grades").optional().field("date", SchemaBuilder.struct().name("pub.grades.date").optional().field("$date", Schema.OPTIONAL_INT64_SCHEMA).build()).field("grade", Schema.OPTIONAL_STRING_SCHEMA).field("score", Schema.OPTIONAL_INT32_SCHEMA).build()).optional().build()).field("name", Schema.OPTIONAL_STRING_SCHEMA).field("restaurant_id", Schema.OPTIONAL_STRING_SCHEMA).build());
    }

    private String getFile(String fileName) throws IOException, URISyntaxException {
        URL jsonResource = this.getClass().getClassLoader().getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(jsonResource.toURI())), StandardCharsets.UTF_8);
    }

    @Test
    @FixFor(value={"DBZ-5796"})
    public void shouldConvertNullNodeToOptionalBytes() throws Exception {
        this.jsonSchemaData = new JsonSchemaData(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.OPTIONAL_BYTES);
        String json = "{\"heartbeat\": 1, \"email\": null}";
        JsonNode testNode = this.mapper.readTree(json);
        Schema payloadSchema = this.jsonSchemaData.toConnectSchema("payload", testNode);
        Field emailField = payloadSchema.field("email");
        Assertions.assertThat((Object)emailField).isNotNull();
        Assertions.assertThat((Comparable)emailField.schema().type()).isEqualTo((Object)Schema.OPTIONAL_BYTES_SCHEMA.schema().type());
    }
}

