/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.channels.jmx;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.JmxUtils;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.SignalChannelReader;
import io.debezium.pipeline.signal.channels.jmx.JmxSignalChannelMXBean;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxSignalChannel
implements SignalChannelReader,
JmxSignalChannelMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxSignalChannel.class);
    private static final String CHANNEL_NAME = "jmx";
    private final Queue<SignalRecord> signals = new ConcurrentLinkedQueue<SignalRecord>();
    private CommonConnectorConfig connectorConfig;

    @Override
    public String name() {
        return CHANNEL_NAME;
    }

    @Override
    public void init(CommonConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        JmxUtils.registerMXBean(this, connectorConfig, "management", "signals");
        LOGGER.info("Registration for Signaling MXBean with the platform server is successfully");
    }

    @Override
    public List<SignalRecord> read() {
        LOGGER.trace("Reading signaling events from queue");
        SignalRecord signalRecord = this.signals.poll();
        if (signalRecord == null) {
            return List.of();
        }
        return List.of(signalRecord);
    }

    @Override
    public void close() {
        JmxUtils.unregisterMXBean(this.connectorConfig, "management", "signals");
    }

    @Override
    public void signal(String id, String type, String data) {
        this.signals.add(new SignalRecord(id, type, data, Map.of()));
    }
}

