/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;

public class RecordAndMetadataHeaderImpl
implements RecordAndMetadata {
    private final Struct record;
    private final Schema dataSchema;
    private final Struct source;
    private final String operation;
    private final Struct transaction;
    private final SchemaAndValue ts_ms;

    public RecordAndMetadataHeaderImpl(Struct record, Schema dataSchema, Headers headers, JsonConverter jsonHeaderConverter) {
        this.record = record;
        this.dataSchema = dataSchema;
        this.source = (Struct)RecordAndMetadataHeaderImpl.getHeaderSchemaAndValue(headers, "source", jsonHeaderConverter).value();
        this.operation = (String)RecordAndMetadataHeaderImpl.getHeaderSchemaAndValue(headers, "op", jsonHeaderConverter).value();
        this.transaction = (Struct)RecordAndMetadataHeaderImpl.getHeaderSchemaAndValue(headers, "transaction", jsonHeaderConverter).value();
        String ts_ms = this.source.getInt64("ts_ms").toString();
        Schema ts_msSchema = this.source.schema().field("ts_ms").schema();
        this.ts_ms = new SchemaAndValue(ts_msSchema, (Object)ts_ms);
    }

    @Override
    public Struct record() {
        return this.record;
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        return this.dataSchema;
    }

    @Override
    public Struct source() {
        return this.source;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Struct transaction() {
        return this.transaction;
    }

    @Override
    public SchemaAndValue timestamp() {
        return this.ts_ms;
    }

    private static SchemaAndValue getHeaderSchemaAndValue(Headers headers, String headerName, JsonConverter jsonHeaderConverter) {
        Header header = headers.lastHeader(headerName);
        return jsonHeaderConverter.toConnectData(null, header.value());
    }
}

