/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source;

import java.util.List;
import java.util.Map;

public class SnapshottingTask {
    private final boolean snapshotSchema;
    private final boolean snapshotData;
    private final List<String> dataCollections;
    private final Map<String, String> filterQueries;
    private final boolean blocking;

    public SnapshottingTask(boolean snapshotSchema, boolean snapshotData, List<String> dataCollections, Map<String, String> filterQueries, boolean blocking) {
        this.snapshotSchema = snapshotSchema;
        this.snapshotData = snapshotData;
        this.dataCollections = dataCollections;
        this.filterQueries = filterQueries;
        this.blocking = blocking;
    }

    public boolean snapshotData() {
        return this.snapshotData;
    }

    public boolean snapshotSchema() {
        return this.snapshotSchema;
    }

    public List<String> getDataCollections() {
        return this.dataCollections;
    }

    public Map<String, String> getFilterQueries() {
        return this.filterQueries;
    }

    public boolean shouldSkipSnapshot() {
        return !this.snapshotSchema() && !this.snapshotData();
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String toString() {
        return "SnapshottingTask [snapshotSchema=" + this.snapshotSchema + ", snapshotData=" + this.snapshotData + "]";
    }
}

