/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.Envelope;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.connect.source.SourceRecord;

public class SourceRecordStats
implements Consumer<SourceRecord> {
    private final AtomicLong EMPTY = new AtomicLong();
    private final EnumMap<Envelope.Operation, AtomicLong> statsByOperation = new EnumMap(Envelope.Operation.class);
    private final AtomicLong tombstones = new AtomicLong();

    @Override
    public void accept(SourceRecord record) {
        if (record.value() == null) {
            this.tombstones.incrementAndGet();
        } else {
            Envelope.Operation op = Envelope.operationFor((SourceRecord)record);
            if (op != null) {
                this.statsByOperation.computeIfAbsent(op, key -> new AtomicLong()).incrementAndGet();
            }
        }
    }

    public long numberOf(Envelope.Operation op) {
        return this.statsByOperation.getOrDefault(op, this.EMPTY).get();
    }

    public long numberOfCreates() {
        return this.numberOf(Envelope.Operation.CREATE);
    }

    public long numberOfDeletes() {
        return this.numberOf(Envelope.Operation.DELETE);
    }

    public long numberOfReads() {
        return this.numberOf(Envelope.Operation.READ);
    }

    public long numberOfUpdates() {
        return this.numberOf(Envelope.Operation.UPDATE);
    }

    public long numberOfTombstones() {
        return this.tombstones.get();
    }

    public SourceRecordStats reset() {
        this.statsByOperation.clear();
        this.tombstones.set(0L);
        return this;
    }

    public String toString() {
        return this.numberOfCreates() + " creates, " + this.numberOfUpdates() + " updates, " + this.numberOfDeletes() + " deletes, " + this.numberOfReads() + " reads";
    }
}

