/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.pipeline.signal.SignalRecord;
import io.debezium.pipeline.signal.channels.FileSignalChannel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FileSignalChannelTest {
    Path signalsData = Paths.get("src", "test", "resources").resolve("debezium_signaling_file.signals.txt");
    Path signalsFile = Paths.get("src", "test", "resources").resolve("debezium_signaling_file.txt");

    @Test
    public void shouldLoadFileSignalsTest() throws IOException {
        Files.copy(this.signalsData, this.signalsFile, StandardCopyOption.REPLACE_EXISTING);
        FileSignalChannel fileSignalChannel = new FileSignalChannel();
        fileSignalChannel.init(this.config());
        List signalRecords = fileSignalChannel.read();
        Assertions.assertThat((List)signalRecords).hasSize(2);
        Assertions.assertThat((boolean)((SignalRecord)signalRecords.get(0)).getData().contains("public.MyFirstTable")).isTrue();
        Files.deleteIfExists(this.signalsFile.toAbsolutePath());
    }

    protected CommonConnectorConfig config() {
        return new CommonConnectorConfig(((Configuration.Builder)Configuration.create().with(FileSignalChannel.SIGNAL_FILE, this.signalsFile.toString())).build(), 0){

            protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
                return null;
            }

            public String getContextName() {
                return null;
            }

            public String getConnectorName() {
                return null;
            }

            public EnumeratedValue getSnapshotMode() {
                return null;
            }

            public Optional<EnumeratedValue> getSnapshotLockingMode() {
                return Optional.empty();
            }
        };
    }
}

