/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

public class CdcSourceTaskContext {
    private final String connectorType;
    private final String connectorName;
    private final String taskId;
    private final Map<String, String> customMetricTags;
    private final Clock clock;
    private final Supplier<Collection<? extends DataCollectionId>> collectionsSupplier;

    public CdcSourceTaskContext(String connectorType, String connectorName, String taskId, Map<String, String> customMetricTags, Supplier<Collection<? extends DataCollectionId>> collectionsSupplier) {
        this.connectorType = connectorType;
        this.connectorName = connectorName;
        this.taskId = taskId;
        this.customMetricTags = customMetricTags;
        this.collectionsSupplier = collectionsSupplier != null ? collectionsSupplier : Collections::emptyList;
        this.clock = Clock.system();
    }

    public CdcSourceTaskContext(String connectorType, String connectorName, Map<String, String> customMetricTags, Supplier<Collection<? extends DataCollectionId>> collectionsSupplier) {
        this(connectorType, connectorName, "0", customMetricTags, collectionsSupplier);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector(this.connectorType, this.connectorName, contextName);
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName, Partition partition) {
        return LoggingContext.forConnector(this.connectorType, this.connectorName, this.taskId, contextName, partition);
    }

    public void temporaryLoggingContext(CommonConnectorConfig connectorConfig, String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector("MySQL", connectorConfig.getLogicalName(), contextName, operation);
    }

    public Clock getClock() {
        return this.clock;
    }

    public String[] capturedDataCollections() {
        return (String[])this.collectionsSupplier.get().stream().map(Object::toString).toArray(String[]::new);
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Map<String, String> getCustomMetricTags() {
        return this.customMetricTags;
    }
}

