/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.processors;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.processors.spi.PostProcessor;
import io.debezium.service.Service;
import io.debezium.service.spi.InjectService;
import io.debezium.service.spi.Startable;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;

@ThreadSafe
public class PostProcessorRegistry
implements Service,
Startable,
Closeable {
    @Immutable
    private final List<PostProcessor> processors;
    private BeanRegistry beanRegistry;

    public PostProcessorRegistry(List<PostProcessor> processors) {
        this.processors = processors == null ? Collections.emptyList() : Collections.unmodifiableList(processors);
    }

    @InjectService
    public void setBeanRegistry(BeanRegistry beanRegistry) {
        this.beanRegistry = beanRegistry;
    }

    @Override
    public void start() {
        for (PostProcessor postProcessor : this.processors) {
            if (!(postProcessor instanceof BeanRegistryAware)) continue;
            ((BeanRegistryAware)((Object)postProcessor)).injectBeanRegistry(this.beanRegistry);
        }
    }

    @Override
    public void close() {
        for (PostProcessor postProcessor : this.processors) {
            postProcessor.close();
        }
    }

    public List<PostProcessor> getProcessors() {
        return this.processors;
    }
}

